/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.blocks;

import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import org.bukkit.configuration.ConfigurationSection;
import us.donut.visualbukkit.VisualBukkit;
import us.donut.visualbukkit.blocks.CodeBlock;
import us.donut.visualbukkit.plugin.PluginBuilder;

public abstract class StatementBlock
extends CodeBlock {
    private ContextMenu disabledContextMenu;
    private boolean disabled;

    public StatementBlock() {
        this.getStyleClass().add((Object)"statement-block");
        MenuItem disableItem = new MenuItem("Disable");
        MenuItem enableItem = new MenuItem("Enable");
        this.contextMenu.getItems().add((Object)disableItem);
        this.disabledContextMenu = new ContextMenu(new MenuItem[]{enableItem});
        disableItem.setOnAction(e -> this.disable());
        enableItem.setOnAction(e -> this.enable());
        this.setOnContextMenuRequested(e -> {
            (this.disabled ? this.disabledContextMenu : this.contextMenu).show((Node)this, e.getScreenX(), e.getScreenY());
            e.consume();
        });
    }

    @Override
    public void unload(ConfigurationSection section) {
        super.unload(section);
        section.set("disabled", this.disabled);
    }

    @Override
    public void load(ConfigurationSection section) throws Exception {
        super.load(section);
        if (section.getBoolean("disabled")) {
            this.disabled = true;
            this.setOpacity(0.5);
        }
    }

    public boolean isEnabled() {
        return !this.disabled;
    }

    public ContextMenu getDisabledContextMenu() {
        return this.disabledContextMenu;
    }

    protected void disable() {
        this.disabled = true;
        if (PluginBuilder.isCodeValid(this.getBlockPane())) {
            this.setOpacity(0.5);
        } else {
            this.disabled = false;
            VisualBukkit.displayError("Cannot disable this block");
        }
    }

    protected void enable() {
        this.disabled = false;
        if (PluginBuilder.isCodeValid(this.getBlockPane())) {
            this.setOpacity(1.0);
        } else {
            this.disabled = true;
            VisualBukkit.displayError("Cannot enable this block");
        }
    }
}

