/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.blocks;

import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.bukkit.configuration.ConfigurationSection;
import us.donut.visualbukkit.blocks.BlockContainer;
import us.donut.visualbukkit.blocks.BlockRegistry;
import us.donut.visualbukkit.blocks.CodeBlock;
import us.donut.visualbukkit.blocks.CopyPasteManager;
import us.donut.visualbukkit.blocks.DragManager;
import us.donut.visualbukkit.blocks.StatementBlock;
import us.donut.visualbukkit.blocks.UndoManager;
import us.donut.visualbukkit.editor.BlockPane;
import us.donut.visualbukkit.plugin.PluginBuilder;

public abstract class ParentBlock
extends StatementBlock
implements BlockContainer {
    private static Color[] colors = new Color[]{Color.LIGHTBLUE, Color.CORNFLOWERBLUE, Color.STEELBLUE};
    private double contextMenuYCoord;

    public ParentBlock() {
        this.getStyleClass().set(0, (Object)"parent-block");
        DragManager.enableBlockContainer(this);
        this.setOnContextMenuRequested(e -> {
            if (this.isEnabled()) {
                this.contextMenu.show((Node)this, e.getScreenX(), e.getScreenY());
                this.contextMenuYCoord = e.getY();
            } else {
                this.getDisabledContextMenu().show((Node)this, e.getScreenX(), e.getScreenY());
            }
            e.consume();
        });
        MenuItem pasteItem = new MenuItem("Paste");
        pasteItem.setOnAction(e -> CopyPasteManager.paste(this, this.contextMenuYCoord));
        this.contextMenu.getItems().add(1, (Object)pasteItem);
    }

    @Override
    public boolean canAccept(CodeBlock block, double yCoord) {
        boolean valid = false;
        if (block instanceof StatementBlock) {
            Pane parent = (Pane)block.getParent();
            int currentIndex = -1;
            if (parent != null) {
                currentIndex = parent.getChildren().indexOf((Object)block);
                parent.getChildren().remove(currentIndex);
            }
            int index = DragManager.getIndexAt((Pane)this, yCoord);
            this.getChildren().add(index, (Object)block);
            valid = PluginBuilder.isCodeValid(block.getBlockPane());
            this.getChildren().remove(index);
            if (parent != null) {
                parent.getChildren().add(currentIndex, (Object)block);
            }
        }
        return valid;
    }

    @Override
    public void accept(CodeBlock block, double yCoord) {
        UndoManager.capture();
        Pane parent = (Pane)block.getParent();
        if (parent != null) {
            parent.getChildren().remove((Object)block);
        }
        this.getChildren().add(DragManager.getIndexAt((Pane)this, yCoord), (Object)block);
        Platform.runLater(block::onDragDrop);
    }

    @Override
    public void onDragDrop() {
        this.color();
    }

    @Override
    public void unload(ConfigurationSection section) {
        super.unload(section);
        List<StatementBlock> children = this.getBlocks(false);
        ConfigurationSection childrenSection = section.createSection("children");
        for (int i = 0; i < children.size(); ++i) {
            CodeBlock child = children.get(i);
            ConfigurationSection childSection = childrenSection.createSection(String.valueOf(i));
            childSection.set("block-type", child.getClass().getCanonicalName());
            child.unload(childSection);
        }
    }

    @Override
    public void load(ConfigurationSection section) throws Exception {
        super.load(section);
        ConfigurationSection childrenSection = section.getConfigurationSection("children");
        if (childrenSection != null) {
            for (String key : childrenSection.getKeys(false)) {
                String blockType;
                ConfigurationSection childSection = childrenSection.getConfigurationSection(key);
                if (childSection == null || (blockType = childSection.getString("block-type")) == null) continue;
                String child = BlockRegistry.getInfo(blockType).createBlock();
                ((CodeBlock)((Object)child)).load(childSection);
                this.getChildren().add((Object)child);
            }
        }
        this.color();
    }

    public String getChildJava() {
        StringBuilder childJava = new StringBuilder();
        this.getBlocks(true).forEach(block -> childJava.append(block.toJava()));
        return childJava.toString();
    }

    public List<StatementBlock> getBlocks(boolean ignoreDisabled) {
        ArrayList<StatementBlock> blocks = new ArrayList<StatementBlock>();
        for (Node child : this.getChildren()) {
            if (!(child instanceof StatementBlock) || ignoreDisabled && !((StatementBlock)child).isEnabled()) continue;
            blocks.add((StatementBlock)child);
        }
        return blocks;
    }

    private void color() {
        int level = 0;
        for (Parent parent = this.getParent(); parent != null && !(parent instanceof BlockPane.BlockArea); parent = parent.getParent()) {
            if (!(parent instanceof ParentBlock)) continue;
            ++level;
        }
        Color color = colors[level % colors.length];
        this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)color, CornerRadii.EMPTY, Insets.EMPTY)}));
        for (Node child : this.getChildren()) {
            if (!(child instanceof ParentBlock)) continue;
            ((ParentBlock)child).color();
        }
    }
}

