/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.blocks;

import com.google.gson.internal.Primitives;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.TreeSet;
import us.donut.visualbukkit.blocks.BlockInfo;
import us.donut.visualbukkit.blocks.ExpressionBlock;
import us.donut.visualbukkit.blocks.ModificationType;
import us.donut.visualbukkit.blocks.ModifierBlock;
import us.donut.visualbukkit.blocks.annotations.Modifier;
import us.donut.visualbukkit.blocks.statements.StatAdd;
import us.donut.visualbukkit.blocks.statements.StatClear;
import us.donut.visualbukkit.blocks.statements.StatDelete;
import us.donut.visualbukkit.blocks.statements.StatRemove;
import us.donut.visualbukkit.blocks.statements.StatSet;

public class ExpressionBlockInfo<T extends ExpressionBlock<?>>
extends BlockInfo<T> {
    private Class<?> returnType;
    private Class<? extends ModifierBlock>[] modifiers;

    public ExpressionBlockInfo(Class<T> blockType) {
        super(blockType);
        for (Class<T> clazz = blockType; clazz != null && clazz != ExpressionBlock.class; clazz = clazz.getSuperclass()) {
            Type type;
            if (!(clazz.getGenericSuperclass() instanceof ParameterizedType) || !((type = ((ParameterizedType)clazz.getGenericSuperclass()).getActualTypeArguments()[0]) instanceof Class)) continue;
            this.returnType = (Class)type;
            break;
        }
        if (this.returnType != null) {
            if (Primitives.isWrapperType(this.returnType)) {
                this.returnType = Primitives.unwrap(this.returnType);
            }
        } else {
            throw new IllegalStateException("Missing return type for " + blockType.getCanonicalName());
        }
        if (blockType.isAnnotationPresent(Modifier.class)) {
            TreeSet<Class> modifiers = new TreeSet<Class>(Comparator.comparing(Class::getSimpleName));
            for (ModificationType modificationType : blockType.getAnnotation(Modifier.class).value()) {
                Class modifierBlockClass = null;
                switch (modificationType) {
                    case SET: {
                        modifierBlockClass = StatSet.class;
                        break;
                    }
                    case ADD: {
                        modifierBlockClass = StatAdd.class;
                        break;
                    }
                    case REMOVE: {
                        modifierBlockClass = StatRemove.class;
                        break;
                    }
                    case DELETE: {
                        modifierBlockClass = StatDelete.class;
                        break;
                    }
                    case CLEAR: {
                        modifierBlockClass = StatClear.class;
                    }
                }
                modifiers.add(modifierBlockClass);
            }
            this.modifiers = modifiers.toArray(new Class[0]);
        }
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public Class<? extends ModifierBlock>[] getModifiers() {
        return this.modifiers;
    }
}

