/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.blocks;

import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.MenuItem;
import us.donut.visualbukkit.blocks.BlockRegistry;
import us.donut.visualbukkit.blocks.CodeBlock;
import us.donut.visualbukkit.blocks.ExpressionBlockInfo;
import us.donut.visualbukkit.blocks.StatementBlock;
import us.donut.visualbukkit.blocks.expressions.ExprAnd;
import us.donut.visualbukkit.blocks.expressions.ExprOr;
import us.donut.visualbukkit.blocks.expressions.ExprStringConcatenation;
import us.donut.visualbukkit.blocks.syntax.ExpressionParameter;

public abstract class ExpressionBlock<T>
extends CodeBlock {
    public ExpressionBlock() {
        this.setOnMouseMoved(e -> {
            this.setStyle("-fx-background-color: yellow;");
            Parent parent = this.getParent();
            while (!(parent instanceof StatementBlock)) {
                if (parent instanceof ExpressionBlock) {
                    parent.setStyle(null);
                }
                parent = parent.getParent();
            }
            e.consume();
        });
        this.setOnMouseExited(e -> {
            this.setStyle(null);
            e.consume();
        });
        MenuItem addStringItem = new MenuItem("Add string");
        addStringItem.setOnAction(e -> {
            ExprStringConcatenation concatExpr = new ExprStringConcatenation();
            ExpressionParameter expressionParameter = (ExpressionParameter)this.getParent();
            expressionParameter.setExpression(concatExpr);
            ((ExpressionParameter)concatExpr.getParameter(0)).setExpression(this);
        });
        MenuItem addAndItem = new MenuItem("Add 'and'");
        addAndItem.setOnAction(e -> {
            ExprAnd andExpr = new ExprAnd();
            ExpressionParameter expressionParameter = (ExpressionParameter)this.getParent();
            expressionParameter.setExpression(andExpr);
            ((ExpressionParameter)andExpr.getParameter(0)).setExpression(this);
        });
        MenuItem addOrItem = new MenuItem("Add 'or'");
        addOrItem.setOnAction(e -> {
            ExprOr orExpr = new ExprOr();
            ExpressionParameter expressionParameter = (ExpressionParameter)this.getParent();
            expressionParameter.setExpression(orExpr);
            ((ExpressionParameter)orExpr.getParameter(0)).setExpression(this);
        });
        this.setOnContextMenuRequested(e -> {
            this.contextMenu.show((Node)this, e.getScreenX(), e.getScreenY());
            ExpressionParameter expressionParameter = (ExpressionParameter)this.getParent();
            if (this.getReturnType() == String.class || expressionParameter.getReturnType() == String.class) {
                if (!this.contextMenu.getItems().contains((Object)addStringItem)) {
                    this.contextMenu.getItems().add((Object)addStringItem);
                }
            } else {
                this.contextMenu.getItems().remove((Object)addStringItem);
            }
            if (this.getReturnType() == Boolean.TYPE || expressionParameter.getReturnType() == Boolean.TYPE) {
                if (!this.contextMenu.getItems().contains((Object)addAndItem)) {
                    this.contextMenu.getItems().addAll((Object[])new MenuItem[]{addAndItem, addOrItem});
                }
            } else {
                this.contextMenu.getItems().removeAll((Object[])new MenuItem[]{addAndItem, addOrItem});
            }
            for (Parent parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof StatementBlock)) continue;
                ((StatementBlock)parent).contextMenu.hide();
                break;
            }
            e.consume();
        });
    }

    public Class<?> getReturnType() {
        return ((ExpressionBlockInfo)BlockRegistry.getInfo(this)).getReturnType();
    }
}

