/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.blocks;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import us.donut.visualbukkit.blocks.ExpressionBlock;
import us.donut.visualbukkit.blocks.syntax.ChoiceParameter;
import us.donut.visualbukkit.blocks.syntax.SyntaxNode;

public abstract class EnumBlock<T extends Enum<?>>
extends ExpressionBlock<T> {
    private static Map<Class<?>, String[]> constants = new HashMap();

    @Override
    protected final SyntaxNode init() {
        return new SyntaxNode(new ChoiceParameter(constants.computeIfAbsent(this.getClass(), key -> this.computeConstants())));
    }

    protected String[] computeConstants() {
        return (String[])Arrays.stream(this.getEnum().getEnumConstants()).map(Enum::name).sorted().toArray(String[]::new);
    }

    @Override
    public final String toJava() {
        return this.getEnum().getCanonicalName() + "." + this.arg(0);
    }

    public final Class<? extends Enum<?>> getEnum() {
        return this.getReturnType();
    }
}

