/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.blocks;

import java.util.UUID;
import org.bukkit.configuration.ConfigurationSection;
import us.donut.visualbukkit.blocks.ModifiableExpressionBlock;
import us.donut.visualbukkit.blocks.ModificationType;
import us.donut.visualbukkit.blocks.syntax.SyntaxNode;

public class EmptyExpressionBlock<T>
extends ModifiableExpressionBlock<T> {
    private Class<T> returnType;

    public EmptyExpressionBlock(Class<T> returnType) {
        this.returnType = returnType;
    }

    @Override
    protected SyntaxNode init() {
        return new SyntaxNode(new Object[0]);
    }

    @Override
    public String toJava() {
        return "((" + this.returnType.getCanonicalName() + ") null)";
    }

    @Override
    public String modify(ModificationType modificationType, String delta) {
        return this.getReturnType().getCanonicalName() + " a" + UUID.randomUUID().toString().replace("-", "") + "=" + delta + ";";
    }

    @Override
    public Class<T> getReturnType() {
        return this.returnType;
    }

    @Override
    public void unload(ConfigurationSection section) {
    }

    @Override
    public void load(ConfigurationSection section) {
    }
}

