/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.blocks;

import java.util.HashMap;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.image.Image;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import us.donut.visualbukkit.blocks.BlockContainer;
import us.donut.visualbukkit.blocks.BlockInfo;
import us.donut.visualbukkit.blocks.CodeBlock;

public class DragManager {
    private static Map<Dragboard, CodeBlock> blockTransfers = new HashMap<Dragboard, CodeBlock>();
    private static Map<BlockContainer, Map<Integer, Boolean>> validationCache = new HashMap<BlockContainer, Map<Integer, Boolean>>();

    public static void enableDragging(Node node) {
        if (!(node instanceof CodeBlock) && !(node instanceof BlockInfo.Node)) {
            throw new IllegalArgumentException();
        }
        node.setOnDragDetected(e -> {
            ClipboardContent content = new ClipboardContent();
            content.putString("block-transfer");
            Dragboard dragboard = node.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
            SnapshotParameters snapshotParameters = new SnapshotParameters();
            snapshotParameters.setFill((Paint)Color.TRANSPARENT);
            dragboard.setDragView((Image)node.snapshot(snapshotParameters, null));
            dragboard.setContent((Map)content);
            e.consume();
        });
        node.setOnDragDone(e -> {
            blockTransfers.remove(e.getDragboard());
            validationCache.clear();
        });
    }

    public static <T extends Pane> void enableBlockContainer(T container) {
        container.setOnDragOver(e -> {
            int cacheIndex = DragManager.getIndexAt(container, e.getY());
            Map cache = validationCache.computeIfAbsent((BlockContainer)container, c -> new HashMap());
            Boolean cachedValue = (Boolean)cache.get(cacheIndex);
            if (cachedValue == null) {
                CodeBlock block;
                Object source = e.getGestureSource();
                CodeBlock codeBlock = source instanceof CodeBlock ? (CodeBlock)source : (block = source instanceof BlockInfo.Node ? ((BlockInfo.Node)((Object)((Object)source))).getBlockInfo().createBlock() : null);
                if (block != null && !block.equals(container) && !DragManager.isChild(container, (Pane)block)) {
                    boolean valid = ((BlockContainer)container).canAccept(block, e.getY());
                    cache.put(cacheIndex, valid);
                    if (valid) {
                        e.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
                        blockTransfers.put(e.getDragboard(), block);
                    }
                }
            } else if (cachedValue.booleanValue()) {
                e.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
            }
            e.consume();
        });
        container.setOnDragDropped(e -> {
            ((BlockContainer)container).accept(blockTransfers.get(e.getDragboard()), e.getY());
            e.setDropCompleted(true);
            e.consume();
        });
    }

    public static int getIndexAt(Pane pane, double y) {
        for (int i = 0; i < pane.getChildren().size(); ++i) {
            Node node = (Node)pane.getChildren().get(i);
            if (!(node instanceof CodeBlock) || !(node.getLayoutY() > y)) continue;
            return i;
        }
        return pane.getChildren().isEmpty() ? 0 : pane.getChildren().size();
    }

    private static boolean isChild(Pane child, Pane parent) {
        for (Node node : parent.getChildrenUnmodifiable()) {
            if (!child.equals(node) && (!(node instanceof Pane) || !DragManager.isChild(child, (Pane)node))) continue;
            return true;
        }
        return false;
    }
}

