/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.blocks;

import java.util.List;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.VBox;
import org.bukkit.configuration.ConfigurationSection;
import us.donut.visualbukkit.VisualBukkit;
import us.donut.visualbukkit.blocks.CopyPasteManager;
import us.donut.visualbukkit.blocks.DragManager;
import us.donut.visualbukkit.blocks.syntax.BlockParameter;
import us.donut.visualbukkit.blocks.syntax.SyntaxNode;
import us.donut.visualbukkit.editor.BlockPane;
import us.donut.visualbukkit.editor.SelectorPane;
import us.donut.visualbukkit.util.Loadable;

public abstract class CodeBlock
extends VBox
implements Loadable {
    protected SyntaxNode syntaxNode;
    protected ContextMenu contextMenu;

    public CodeBlock() {
        DragManager.enableDragging((Node)this);
        this.contextMenu = new ContextMenu();
        this.setOnMouseClicked(e -> this.contextMenu.hide());
        this.setOnContextMenuRequested(e -> {
            this.contextMenu.show((Node)this, e.getScreenX(), e.getScreenY());
            e.consume();
        });
        MenuItem copyItem = new MenuItem("Copy");
        MenuItem cutItem = new MenuItem("Cut");
        MenuItem deleteItem = new MenuItem("Delete");
        copyItem.setOnAction(e -> CopyPasteManager.copy(this));
        cutItem.setOnAction(e -> {
            copyItem.getOnAction().handle(e);
            deleteItem.getOnAction().handle(e);
        });
        deleteItem.setOnAction(e -> {
            SelectorPane selectorPane = VisualBukkit.getInstance().getSelectorPane();
            if (selectorPane.canAccept(this, -1.0)) {
                selectorPane.accept(this, -1.0);
            } else {
                VisualBukkit.displayError("Cannot delete block");
            }
        });
        this.contextMenu.getItems().addAll((Object[])new MenuItem[]{copyItem, cutItem, deleteItem});
        this.syntaxNode = this.init();
        this.getChildren().add((Object)this.syntaxNode);
    }

    protected abstract SyntaxNode init();

    public void onDragDrop() {
    }

    public abstract String toJava();

    @Override
    public void unload(ConfigurationSection section) {
        List<BlockParameter> parameters = this.getParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            parameters.get(i).unload(section.createSection("parameters." + i));
        }
    }

    @Override
    public void load(ConfigurationSection section) throws Exception {
        ConfigurationSection parameterSection = section.getConfigurationSection("parameters");
        if (parameterSection != null) {
            List<BlockParameter> parameters = this.getParameters();
            for (int i = 0; i < parameters.size(); ++i) {
                parameters.get(i).load(parameterSection.getConfigurationSection(String.valueOf(i)));
            }
        }
    }

    public boolean isChildOf(Class<? extends CodeBlock> clazz) {
        for (Parent parent = this.getParent(); parent != null && !(parent instanceof BlockPane.BlockArea); parent = parent.getParent()) {
            if (!clazz.isAssignableFrom(parent.getClass())) continue;
            return true;
        }
        return false;
    }

    public String arg(int i) {
        return this.getParameter(i).toJava();
    }

    public List<BlockParameter> getParameters() {
        return this.syntaxNode.getParameters();
    }

    public BlockParameter getParameter(int i) {
        return this.getParameters().get(i);
    }

    public SyntaxNode getSyntaxNode() {
        return this.syntaxNode;
    }

    public ContextMenu getContextMenu() {
        return this.contextMenu;
    }

    public BlockPane getBlockPane() {
        for (Parent parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof BlockPane.BlockArea)) continue;
            return ((BlockPane.BlockArea)parent).getBlockPane();
        }
        return null;
    }
}

