/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.blocks;

import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import us.donut.visualbukkit.blocks.BlockInfo;
import us.donut.visualbukkit.blocks.CodeBlock;
import us.donut.visualbukkit.blocks.EmptyExpressionBlock;
import us.donut.visualbukkit.blocks.ExpressionBlock;
import us.donut.visualbukkit.blocks.ExpressionBlockInfo;
import us.donut.visualbukkit.blocks.StatementBlock;

public class BlockRegistry {
    private static Map<String, BlockInfo<? extends CodeBlock>> blockTypes = new HashMap<String, BlockInfo<? extends CodeBlock>>();

    public static void registerAll() {
        TreeSet<Class<CodeBlock>> blockTypes = new TreeSet<Class<CodeBlock>>((c1, c2) -> c1.equals(c2) ? 0 : (StatementBlock.class.isAssignableFrom((Class<?>)c1) ? -1 : 1));
        blockTypes.addAll(new Reflections("us.donut.visualbukkit.blocks", new Scanner[0]).getSubTypesOf(CodeBlock.class));
        for (Class clazz : blockTypes) {
            if (Modifier.isAbstract(clazz.getModifiers()) || clazz == EmptyExpressionBlock.class) continue;
            BlockInfo blockInfo = ExpressionBlock.class.isAssignableFrom(clazz) ? new ExpressionBlockInfo(clazz) : new BlockInfo(clazz);
            BlockRegistry.blockTypes.put(clazz.getCanonicalName(), blockInfo);
            blockInfo.createBlock();
        }
    }

    public static BlockInfo<? extends CodeBlock> getInfo(String blockType) {
        return blockTypes.get(blockType);
    }

    public static <T extends CodeBlock> BlockInfo<T> getInfo(Class<T> blockType) {
        return BlockRegistry.getInfo(blockType.getCanonicalName());
    }

    public static <T extends CodeBlock> BlockInfo<T> getInfo(T block) {
        return BlockRegistry.getInfo(block.getClass());
    }

    public static Collection<BlockInfo<? extends CodeBlock>> getAll() {
        return Collections.unmodifiableCollection(blockTypes.values());
    }
}

