/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit.blocks;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import org.apache.commons.lang.WordUtils;
import us.donut.visualbukkit.blocks.CodeBlock;
import us.donut.visualbukkit.blocks.DragManager;
import us.donut.visualbukkit.blocks.StatementBlock;
import us.donut.visualbukkit.blocks.TypeHandler;
import us.donut.visualbukkit.blocks.annotations.Category;
import us.donut.visualbukkit.blocks.annotations.Description;
import us.donut.visualbukkit.blocks.annotations.Event;
import us.donut.visualbukkit.blocks.annotations.Name;

public class BlockInfo<T extends CodeBlock> {
    private Class<T> blockType;
    private Constructor<T> constructor;
    private String name;
    private String description;
    private String[] categories;
    private Class<?>[] events;

    public BlockInfo(Class<T> blockType) {
        this.blockType = blockType;
        try {
            this.constructor = blockType.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No constructor for " + blockType.getCanonicalName(), e);
        }
        String string = this.name = blockType.isAnnotationPresent(Name.class) ? blockType.getAnnotation(Name.class).value() : WordUtils.capitalize(TypeHandler.getUserFriendlyName(blockType).replaceFirst(".+? ", ""));
        if (blockType.isAnnotationPresent(Description.class)) {
            this.description = String.join((CharSequence)"\n", blockType.getAnnotation(Description.class).value());
        }
        if (blockType.isAnnotationPresent(Category.class)) {
            this.categories = blockType.getAnnotation(Category.class).value();
        }
        if (blockType.isAnnotationPresent(Event.class)) {
            this.events = blockType.getAnnotation(Event.class).value();
        }
    }

    public Node createNode() {
        return new Node();
    }

    public T createBlock() {
        try {
            return (T)((CodeBlock)this.constructor.newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new UnsupportedOperationException("Block could not be instantiated", e);
        }
    }

    public Class<T> getBlockType() {
        return this.blockType;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getCategories() {
        return this.categories;
    }

    public Class<?>[] getEvents() {
        return this.events;
    }

    public class Node
    extends Label {
        public Node() {
            this.getStyleClass().add((Object)(StatementBlock.class.isAssignableFrom(BlockInfo.this.blockType) ? "statement-block-info-node" : "expression-block-info-node"));
            this.setText(BlockInfo.this.getName());
            DragManager.enableDragging((javafx.scene.Node)this);
            if (BlockInfo.this.description != null) {
                this.setTooltip(new Tooltip(BlockInfo.this.description));
            }
        }

        public BlockInfo<T> getBlockInfo() {
            return BlockInfo.this;
        }
    }
}

