/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit;

import com.sun.javafx.application.LauncherImpl;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.swing.JOptionPane;
import org.apache.commons.lang.exception.ExceptionUtils;
import us.donut.visualbukkit.SplashScreenLoader;
import us.donut.visualbukkit.VisualBukkit;
import us.donut.visualbukkit.util.DataFile;

public class VisualBukkitLauncher {
    public static final String VERSION = "v" + VisualBukkitLauncher.class.getPackage().getSpecificationVersion();
    public static final Path DATA_FOLDER = Paths.get(System.getProperty("user.home"), "Visual Bukkit");
    public static final DataFile DATA_FILE = new DataFile(DATA_FOLDER.resolve("data.yml"));
    public static final Logger LOGGER = Logger.getLogger("VisualBukkit");

    public static void main(String[] args) {
        try {
            if (Files.notExists(DATA_FOLDER, new LinkOption[0])) {
                Files.createDirectory(DATA_FOLDER, new FileAttribute[0]);
            }
            FileHandler fileHandler = new FileHandler(DATA_FOLDER.resolve("log.txt").toString(), true);
            fileHandler.setFormatter(new SimpleFormatter());
            LOGGER.addHandler(fileHandler);
            LauncherImpl.launchApplication(VisualBukkit.class, SplashScreenLoader.class, (String[])new String[0]);
        }
        catch (Exception e) {
            LOGGER.severe(ExceptionUtils.getStackTrace(e));
            JOptionPane.showMessageDialog(null, "Failed to launch Visual Bukkit", "Error", 0);
        }
    }
}

