/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit;

import java.awt.Desktop;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.application.Preloader;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.ToggleGroup;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Duration;
import org.apache.commons.lang.exception.ExceptionUtils;
import us.donut.visualbukkit.VisualBukkitLauncher;
import us.donut.visualbukkit.blocks.BlockRegistry;
import us.donut.visualbukkit.blocks.UndoManager;
import us.donut.visualbukkit.editor.Project;
import us.donut.visualbukkit.editor.ProjectManager;
import us.donut.visualbukkit.editor.SelectorPane;
import us.donut.visualbukkit.plugin.PluginBuilder;

public class VisualBukkit
extends Application {
    private static VisualBukkit instance;
    private BorderPane rootPane = new BorderPane();
    private SplitPane splitPane = new SplitPane();
    private Scene scene = new Scene((Parent)this.rootPane, 500.0, 500.0);
    private Stage primaryStage;
    private SelectorPane selectorPane;
    private Timeline autoSaveTimer;
    private int fontSize;

    public VisualBukkit() {
        if (instance != null) {
            throw new IllegalStateException();
        }
        instance = this;
    }

    public void start(Stage primaryStage) {
        Thread.setDefaultUncaughtExceptionHandler((thread, e) -> Platform.runLater(() -> VisualBukkit.displayException("An exception occurred", e)));
        this.primaryStage = primaryStage;
        Platform.runLater(this::load);
    }

    private void load() {
        this.primaryStage.setTitle("Visual Bukkit " + VisualBukkitLauncher.VERSION);
        this.primaryStage.setMaximized(true);
        this.primaryStage.setScene(this.scene);
        this.rootPane.getStylesheets().add((Object)"/style.css");
        try (InputStream inputStream = VisualBukkit.class.getResourceAsStream("/icon.png");){
            this.primaryStage.getIcons().add((Object)new Image(inputStream));
        }
        catch (IOException e) {
            VisualBukkit.displayException("Failed to load icon", e);
        }
        BlockRegistry.registerAll();
        PluginBuilder.init();
        this.setupMenuBar();
        this.setupSaving();
        Object[] objectArray = new Node[3];
        this.selectorPane = new SelectorPane();
        objectArray[0] = this.selectorPane;
        objectArray[1] = new Pane();
        objectArray[2] = new Pane();
        this.splitPane.getItems().addAll(objectArray);
        this.rootPane.setCenter((Node)this.splitPane);
        this.notifyPreloader((Preloader.PreloaderNotification)new Preloader.ProgressNotification(1.0));
        this.primaryStage.show();
        this.splitPane.setDividerPositions(new double[]{0.2, 0.825});
        ProjectManager.loadProjects();
    }

    private void setupMenuBar() {
        MenuItem saveItem = new MenuItem("Save");
        MenuItem exitItem = new MenuItem("Exit");
        exitItem.setOnAction(e -> this.primaryStage.fireEvent((Event)new WindowEvent((Window)this.primaryStage, WindowEvent.WINDOW_CLOSE_REQUEST)));
        saveItem.setOnAction(e -> {
            if (ProjectManager.getCurrentProject() != null) {
                try {
                    ProjectManager.getCurrentProject().save();
                    VisualBukkit.displayMessage("Successfully saved project");
                }
                catch (IOException ex) {
                    VisualBukkit.displayException("Failed to save project", ex);
                }
            }
        });
        Menu fileMenu = new Menu("File");
        fileMenu.getItems().addAll((Object[])new MenuItem[]{saveItem, exitItem});
        MenuItem createItem = new MenuItem("Create");
        MenuItem openItem = new MenuItem("Open");
        MenuItem deleteItem = new MenuItem("Delete");
        createItem.setOnAction(e -> ProjectManager.promptCreateProject(true));
        openItem.setOnAction(e -> ProjectManager.promptOpenProject());
        deleteItem.setOnAction(e -> ProjectManager.promptDeleteProject());
        Menu projectMenu = new Menu("Project");
        projectMenu.getItems().addAll((Object[])new MenuItem[]{createItem, openItem, deleteItem});
        MenuItem undoItem = new MenuItem("Undo");
        MenuItem redoItem = new MenuItem("Redo");
        undoItem.setOnAction(e -> UndoManager.undo());
        redoItem.setOnAction(e -> UndoManager.redo());
        Menu editMenu = new Menu("Edit");
        editMenu.getItems().addAll((Object[])new MenuItem[]{undoItem, redoItem});
        Menu fontSizeMenu = new Menu("Font Size");
        ToggleGroup fontToggleGroup = new ToggleGroup();
        this.fontSize = VisualBukkitLauncher.DATA_FILE.getConfig().getInt("font-size", 14);
        for (int i = 8; i <= 36; ++i) {
            int size = i;
            RadioMenuItem sizeItem = new RadioMenuItem(String.valueOf(size));
            sizeItem.setOnAction(e -> {
                this.fontSize = size;
                this.rootPane.setStyle("-fx-font-size:" + this.fontSize + ";");
                VisualBukkitLauncher.DATA_FILE.getConfig().set("font-size", this.fontSize);
            });
            fontToggleGroup.getToggles().add((Object)sizeItem);
            fontSizeMenu.getItems().add((Object)sizeItem);
            if (size != this.fontSize) continue;
            sizeItem.setSelected(true);
            this.rootPane.setStyle("-fx-font-size:" + this.fontSize + ";");
        }
        Menu autosaveMenu = new Menu("Autosave");
        ToggleGroup autosaveToggleGroup = new ToggleGroup();
        int autoSaveDuration = VisualBukkitLauncher.DATA_FILE.getConfig().getInt("autosave", -1);
        for (int duration : new int[]{5, 15, 30, -1}) {
            RadioMenuItem durationItem;
            if (duration != -1) {
                durationItem = new RadioMenuItem(duration + " minutes");
                durationItem.setOnAction(e -> {
                    if (this.autoSaveTimer != null) {
                        this.autoSaveTimer.stop();
                    }
                    this.autoSave(duration);
                    VisualBukkitLauncher.DATA_FILE.getConfig().set("autosave", duration);
                });
            } else {
                durationItem = new RadioMenuItem("Never");
                durationItem.setOnAction(e -> {
                    if (this.autoSaveTimer != null) {
                        this.autoSaveTimer.stop();
                    }
                    VisualBukkitLauncher.DATA_FILE.getConfig().set("autosave", null);
                });
            }
            autosaveToggleGroup.getToggles().add((Object)durationItem);
            autosaveMenu.getItems().add((Object)durationItem);
            if (duration != autoSaveDuration) continue;
            durationItem.setSelected(true);
            if (autoSaveDuration == -1) continue;
            this.autoSave(duration);
        }
        Menu settingsMenu = new Menu("Settings");
        settingsMenu.getItems().addAll((Object[])new MenuItem[]{fontSizeMenu, autosaveMenu});
        MenuItem githubItem = new MenuItem("Github");
        githubItem.setOnAction(e -> this.openURI("https://github.com/OfficialDonut/VisualBukkit"));
        MenuItem spigotItem = new MenuItem("Spigot");
        spigotItem.setOnAction(e -> this.openURI("https://www.spigotmc.org/resources/visual-bukkit-create-plugins.76474/"));
        MenuItem discordItem = new MenuItem("Discord");
        discordItem.setOnAction(e -> this.openURI("https://discord.gg/ugkvGpu"));
        Menu supportMenu = new Menu("Support");
        supportMenu.getItems().addAll((Object[])new MenuItem[]{githubItem, spigotItem, discordItem});
        this.rootPane.setTop((Node)new MenuBar(new Menu[]{fileMenu, projectMenu, editMenu, settingsMenu, supportMenu}));
    }

    private void openURI(String uri) {
        try {
            Desktop.getDesktop().browse(URI.create(uri));
        }
        catch (IOException e) {
            VisualBukkit.displayException("Failed to open " + uri, e);
        }
    }

    private void autoSave(double minutes) {
        this.autoSaveTimer = new Timeline(new KeyFrame[]{new KeyFrame(Duration.minutes((double)minutes), event -> {
            Project project = ProjectManager.getCurrentProject();
            if (project != null) {
                try {
                    project.save();
                    VisualBukkitLauncher.DATA_FILE.save();
                }
                catch (IOException ex) {
                    Platform.runLater(() -> VisualBukkit.displayException("Failed to autosave", ex));
                }
            }
        }, new KeyValue[0])});
        this.autoSaveTimer.setCycleCount(-1);
        this.autoSaveTimer.play();
    }

    private void setupSaving() {
        this.scene.addEventFilter(KeyEvent.KEY_PRESSED, e -> {
            if (e.isShortcutDown() && e.getCode() == KeyCode.S && ProjectManager.getCurrentProject() != null) {
                try {
                    ProjectManager.getCurrentProject().save();
                    VisualBukkitLauncher.DATA_FILE.save();
                    VisualBukkit.displayMessage("Successfully saved project");
                }
                catch (IOException ex) {
                    VisualBukkit.displayException("Failed to save project", ex);
                }
                e.consume();
            }
        });
        Alert saveAlert = new Alert(Alert.AlertType.CONFIRMATION, "Do you want to save?", new ButtonType[0]);
        saveAlert.setHeaderText(null);
        saveAlert.setGraphic(null);
        ButtonType saveButton = new ButtonType("Save and exit");
        ButtonType noSaveButton = new ButtonType("Exit without saving");
        saveAlert.getButtonTypes().setAll((Object[])new ButtonType[]{saveButton, noSaveButton, ButtonType.CANCEL});
        this.primaryStage.setOnCloseRequest(e -> {
            if (ProjectManager.getCurrentProject() != null) {
                saveAlert.showAndWait().ifPresent(buttonType -> {
                    if (buttonType.equals(saveButton)) {
                        try {
                            ProjectManager.getCurrentProject().save();
                            VisualBukkitLauncher.DATA_FILE.save();
                        }
                        catch (IOException ex) {
                            VisualBukkit.displayException("Failed to save project", ex);
                        }
                        Platform.exit();
                    } else if (buttonType.equals(noSaveButton)) {
                        Platform.exit();
                    }
                });
            } else {
                Platform.exit();
            }
            e.consume();
        });
    }

    public static void displayMessage(String message) {
        Alert alert = new Alert(Alert.AlertType.INFORMATION, message, new ButtonType[]{ButtonType.CLOSE});
        alert.setHeaderText(null);
        alert.setGraphic(null);
        alert.showAndWait();
    }

    public static void displayError(String message) {
        Alert alert = new Alert(Alert.AlertType.ERROR, message, new ButtonType[]{ButtonType.CLOSE});
        alert.setHeaderText(null);
        alert.setGraphic(null);
        alert.showAndWait();
    }

    public static void displayException(String message, Throwable e) {
        VisualBukkitLauncher.LOGGER.severe(ExceptionUtils.getStackTrace(e));
        Alert alert = new Alert(Alert.AlertType.ERROR, null, new ButtonType[]{ButtonType.CLOSE});
        alert.setHeaderText(null);
        alert.setGraphic(null);
        VBox content = new VBox(5.0, new Node[]{new Text(message), new TextArea(ExceptionUtils.getStackTrace(e))});
        alert.getDialogPane().setContent((Node)content);
        alert.showAndWait();
    }

    public static VisualBukkit getInstance() {
        return instance;
    }

    public Stage getPrimaryStage() {
        return this.primaryStage;
    }

    public Scene getScene() {
        return this.scene;
    }

    public BorderPane getRootPane() {
        return this.rootPane;
    }

    public SplitPane getSplitPane() {
        return this.splitPane;
    }

    public SelectorPane getSelectorPane() {
        return this.selectorPane;
    }

    public int getFontSize() {
        return this.fontSize;
    }
}

