/*
 * Decompiled with CFR 0.152.
 */
package us.donut.visualbukkit;

import java.io.InputStream;
import javafx.application.Preloader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import us.donut.visualbukkit.VisualBukkit;

public class SplashScreenLoader
extends Preloader {
    private Stage primaryStage;

    public void start(Stage primaryStage) throws Exception {
        this.primaryStage = primaryStage;
        BorderPane rootPane = new BorderPane();
        rootPane.getStylesheets().add((Object)"/style.css");
        try (InputStream inputStream = VisualBukkit.class.getResourceAsStream("/icon.png");){
            Image icon = new Image(inputStream, 150.0, 150.0, true, true);
            VBox vBox = new VBox(15.0, new Node[]{new Label("Visual Bukkit"), new ImageView(icon)});
            vBox.getStyleClass().add((Object)"splash-screen");
            rootPane.setCenter((Node)vBox);
            primaryStage.setTitle("Visual Bukkit v" + SplashScreenLoader.class.getPackage().getSpecificationVersion());
            primaryStage.setScene(new Scene((Parent)rootPane, 600.0, 500.0));
            primaryStage.getIcons().add((Object)icon);
            primaryStage.initStyle(StageStyle.UNDECORATED);
            primaryStage.show();
        }
    }

    public void handleApplicationNotification(Preloader.PreloaderNotification info) {
        if (info instanceof Preloader.ProgressNotification && ((Preloader.ProgressNotification)info).getProgress() == 1.0) {
            this.primaryStage.close();
        }
    }
}

