/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.tabpane.skin;

import com.sun.javafx.scene.control.skin.TabPaneSkin;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.css.StyleOrigin;
import javafx.css.StyleableProperty;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.image.Image;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import org.eclipse.fx.ui.controls.tabpane.DndTabPaneFactory;

public class DnDTabPaneSkin
extends TabPaneSkin
implements DndTabPaneFactory.DragSetup {
    private static Tab DRAGGED_TAB;
    public static final DataFormat TAB_MOVE;
    private Object noneEnum;
    private StyleableProperty<Object> openAnimation;
    private StyleableProperty<Object> closeAnimation;
    private Function<Tab, Boolean> startFunction;
    private Consumer<Tab> dragFinishedConsumer;
    private Consumer<DndTabPaneFactory.FeedbackData> feedbackConsumer;
    private Consumer<DndTabPaneFactory.DroppedData> dropConsumer;
    private Function<Tab, String> clipboardDataFunction;

    public DnDTabPaneSkin(TabPane tabPane) {
        super(tabPane);
        this.hookTabFolderSkin();
    }

    private void hookTabFolderSkin() {
        block5: {
            try {
                Field field = TabPaneSkin.class.getDeclaredField("tabHeaderArea");
                field.setAccessible(true);
                StackPane stackPane = (StackPane)field.get(this);
                stackPane.setOnDragOver(dragEvent -> dragEvent.consume());
                Field field2 = stackPane.getClass().getDeclaredField("headersRegion");
                field2.setAccessible(true);
                StackPane stackPane2 = (StackPane)field2.get(stackPane);
                EventHandler eventHandler = this::tabPane_handleDragStart;
                EventHandler eventHandler2 = this::tabPane_handleDragDone;
                for (Class<?>[] classArray : stackPane2.getChildren()) {
                    classArray.addEventHandler(MouseEvent.DRAG_DETECTED, eventHandler);
                    classArray.addEventHandler(DragEvent.DRAG_DONE, eventHandler2);
                }
                stackPane2.getChildren().addListener(change -> {
                    while (change.next()) {
                        if (change.wasRemoved()) {
                            for (Node node : change.getRemoved()) {
                                node.removeEventHandler(MouseEvent.DRAG_DETECTED, eventHandler);
                            }
                            for (Node node : change.getRemoved()) {
                                node.removeEventHandler(DragEvent.DRAG_DONE, eventHandler2);
                            }
                        }
                        if (!change.wasAdded()) continue;
                        for (Node node : change.getAddedSubList()) {
                            node.addEventHandler(MouseEvent.DRAG_DETECTED, eventHandler);
                        }
                        for (Node node : change.getAddedSubList()) {
                            node.addEventHandler(DragEvent.DRAG_DONE, eventHandler2);
                        }
                    }
                });
                stackPane.addEventHandler(DragEvent.DRAG_OVER, arg_0 -> this.lambda$hookTabFolderSkin$4((Pane)stackPane, (Pane)stackPane2, arg_0));
                stackPane.addEventHandler(DragEvent.DRAG_DROPPED, arg_0 -> this.lambda$hookTabFolderSkin$5((Pane)stackPane, (Pane)stackPane2, arg_0));
                stackPane.addEventHandler(DragEvent.DRAG_EXITED, this::tabPane_handleDragDone);
                Object object = TabPaneSkin.class.getDeclaredField("openTabAnimation");
                ((Field)object).setAccessible(true);
                this.openAnimation = (StyleableProperty)((Field)object).get(this);
                object = TabPaneSkin.class.getDeclaredField("closeTabAnimation");
                ((Field)object).setAccessible(true);
                this.closeAnimation = (StyleableProperty)((Field)object).get(this);
                for (Class<?> clazz : this.getClass().getDeclaredClasses()) {
                    if (!"TabAnimation".equals(clazz.getSimpleName())) continue;
                    for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
                        if (!"NONE".equals(enum_.name())) continue;
                        this.noneEnum = enum_;
                        break block5;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    void tabPane_handleDragStart(MouseEvent mouseEvent) {
        try {
            Field field = mouseEvent.getSource().getClass().getDeclaredField("tab");
            field.setAccessible(true);
            Tab tab = (Tab)field.get(mouseEvent.getSource());
            if (tab != null && this.efx_canStartDrag(tab)) {
                DRAGGED_TAB = tab;
                Node node = (Node)mouseEvent.getSource();
                Dragboard dragboard = node.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
                WritableImage writableImage = node.snapshot(new SnapshotParameters(), null);
                PixelReader pixelReader = writableImage.getPixelReader();
                int n = 10;
                int n2 = 10;
                int n3 = (int)writableImage.getWidth();
                int n4 = (int)writableImage.getHeight();
                WritableImage writableImage2 = new WritableImage(n3 + n, n4 + n2);
                PixelWriter pixelWriter = writableImage2.getPixelWriter();
                int n5 = 0;
                for (int i = 0; i < n3 + n; ++i) {
                    for (n5 = 0; n5 < n4 + n2; ++n5) {
                        if (i >= n && i <= n3 + n && n5 >= n2 && n5 <= n4 + n2) {
                            pixelWriter.setColor(i, n5, pixelReader.getColor(i - n, n5 - n2));
                            continue;
                        }
                        pixelWriter.setColor(i, n5, Color.TRANSPARENT);
                    }
                }
                dragboard.setDragView((Image)writableImage2, writableImage2.getWidth(), writableImage2.getHeight() * -1.0);
                ClipboardContent clipboardContent = new ClipboardContent();
                String string = this.efx_getClipboardContent(tab);
                if (string != null) {
                    clipboardContent.put((Object)TAB_MOVE, (Object)string);
                }
                dragboard.setContent((Map)clipboardContent);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    void tabPane_handleDragOver(Pane pane, Pane pane2, DragEvent dragEvent) {
        Tab tab = DRAGGED_TAB;
        if (tab == null) {
            return;
        }
        dragEvent.consume();
        double d = dragEvent.getX() - pane2.getBoundsInParent().getMinX();
        Object object = null;
        DndTabPaneFactory.DropType dropType = DndTabPaneFactory.DropType.AFTER;
        for (Node node : pane2.getChildren()) {
            Bounds bounds = node.getBoundsInParent();
            if (!(bounds.getMaxX() > d)) continue;
            if (bounds.getMinX() + bounds.getWidth() / 2.0 > d) {
                object = node;
                dropType = DndTabPaneFactory.DropType.BEFORE;
                break;
            }
            object = node;
            dropType = DndTabPaneFactory.DropType.AFTER;
            break;
        }
        if (object == null && pane2.getChildren().size() > 0) {
            object = (Node)pane2.getChildren().get(pane2.getChildren().size() - 1);
            dropType = DndTabPaneFactory.DropType.AFTER;
        }
        if (object != null) {
            try {
                int n;
                Node node;
                Field field = object.getClass().getDeclaredField("tab");
                field.setAccessible(true);
                node = (Tab)field.get(object);
                boolean bl = false;
                if (node == tab) {
                    bl = true;
                } else if (dropType == DndTabPaneFactory.DropType.BEFORE) {
                    n = ((TabPane)this.getSkinnable()).getTabs().indexOf((Object)node);
                    if (n > 0 && ((TabPane)this.getSkinnable()).getTabs().get(n - 1) == tab) {
                        bl = true;
                    }
                } else {
                    n = ((TabPane)this.getSkinnable()).getTabs().indexOf((Object)node);
                    if (n + 1 < ((TabPane)this.getSkinnable()).getTabs().size() && ((TabPane)this.getSkinnable()).getTabs().get(n + 1) == tab) {
                        bl = true;
                    }
                }
                if (bl) {
                    this.efx_dragFeedback(tab, null, null, DndTabPaneFactory.DropType.NONE);
                    return;
                }
                Bounds bounds = object.getBoundsInLocal();
                bounds = object.localToScene(bounds);
                bounds = ((TabPane)this.getSkinnable()).sceneToLocal(bounds);
                this.efx_dragFeedback(tab, (Tab)node, bounds, dropType);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            dragEvent.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
        } else {
            this.efx_dragFeedback(tab, null, null, DndTabPaneFactory.DropType.NONE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tabPane_handleDragDropped(Pane pane, Pane pane2, DragEvent dragEvent) {
        Tab tab = DRAGGED_TAB;
        if (tab == null) {
            return;
        }
        double d = dragEvent.getX() - pane2.getBoundsInParent().getMinX();
        Object object = null;
        DndTabPaneFactory.DropType dropType = DndTabPaneFactory.DropType.AFTER;
        for (Node node : pane2.getChildren()) {
            Bounds bounds = node.getBoundsInParent();
            if (!(bounds.getMaxX() > d)) continue;
            if (bounds.getMinX() + bounds.getWidth() / 2.0 > d) {
                object = node;
                dropType = DndTabPaneFactory.DropType.BEFORE;
                break;
            }
            object = node;
            dropType = DndTabPaneFactory.DropType.AFTER;
            break;
        }
        if (object == null && pane2.getChildren().size() > 0) {
            object = (Node)pane2.getChildren().get(pane2.getChildren().size() - 1);
            dropType = DndTabPaneFactory.DropType.AFTER;
        }
        if (object != null) {
            block18: {
                try {
                    int n;
                    Node node;
                    Field field = object.getClass().getDeclaredField("tab");
                    field.setAccessible(true);
                    node = (Tab)field.get(object);
                    boolean bl = false;
                    if (node == null) {
                        dragEvent.setDropCompleted(false);
                        return;
                    }
                    if (node == tab) {
                        bl = true;
                    } else if (dropType == DndTabPaneFactory.DropType.BEFORE) {
                        n = ((TabPane)this.getSkinnable()).getTabs().indexOf((Object)node);
                        if (n > 0 && ((TabPane)this.getSkinnable()).getTabs().get(n - 1) == tab) {
                            bl = true;
                        }
                    } else {
                        n = ((TabPane)this.getSkinnable()).getTabs().indexOf((Object)node);
                        if (n + 1 < ((TabPane)this.getSkinnable()).getTabs().size() && ((TabPane)this.getSkinnable()).getTabs().get(n + 1) == tab) {
                            bl = true;
                        }
                    }
                    if (!bl) {
                        StyleOrigin styleOrigin = this.openAnimation.getStyleOrigin();
                        StyleOrigin styleOrigin2 = this.closeAnimation.getStyleOrigin();
                        Object object2 = this.openAnimation.getValue();
                        Object object3 = this.closeAnimation.getValue();
                        try {
                            this.openAnimation.setValue(this.noneEnum);
                            this.closeAnimation.setValue(this.noneEnum);
                            this.efx_dropped(tab, (Tab)node, dropType);
                            dragEvent.setDropCompleted(true);
                            break block18;
                        }
                        finally {
                            this.openAnimation.applyStyle(styleOrigin, object2);
                            this.closeAnimation.applyStyle(styleOrigin2, object3);
                        }
                    }
                    dragEvent.setDropCompleted(false);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            dragEvent.consume();
        }
    }

    void tabPane_handleDragDone(DragEvent dragEvent) {
        Tab tab = DRAGGED_TAB;
        if (tab == null) {
            return;
        }
        this.efx_dragFinished(tab);
    }

    @Override
    public void setClipboardDataFunction(Function<Tab, String> function) {
        this.clipboardDataFunction = function;
    }

    @Override
    public void setStartFunction(Function<Tab, Boolean> function) {
        this.startFunction = function;
    }

    @Override
    public void setDragFinishedConsumer(Consumer<Tab> consumer) {
        this.dragFinishedConsumer = consumer;
    }

    @Override
    public void setFeedbackConsumer(Consumer<DndTabPaneFactory.FeedbackData> consumer) {
        this.feedbackConsumer = consumer;
    }

    @Override
    public void setDropConsumer(Consumer<DndTabPaneFactory.DroppedData> consumer) {
        this.dropConsumer = consumer;
    }

    private boolean efx_canStartDrag(Tab tab) {
        if (this.startFunction != null) {
            return this.startFunction.apply(tab);
        }
        return true;
    }

    private void efx_dragFeedback(Tab tab, Tab tab2, Bounds bounds, DndTabPaneFactory.DropType dropType) {
        if (this.feedbackConsumer != null) {
            this.feedbackConsumer.accept(new DndTabPaneFactory.FeedbackData(tab, tab2, bounds, dropType));
        }
    }

    private void efx_dropped(Tab tab, Tab tab2, DndTabPaneFactory.DropType dropType) {
        if (this.dropConsumer != null) {
            this.dropConsumer.accept(new DndTabPaneFactory.DroppedData(tab, tab2, dropType));
        }
    }

    private void efx_dragFinished(Tab tab) {
        if (this.dragFinishedConsumer != null) {
            this.dragFinishedConsumer.accept(tab);
        }
    }

    private String efx_getClipboardContent(Tab tab) {
        if (this.clipboardDataFunction != null) {
            return this.clipboardDataFunction.apply(tab);
        }
        return System.identityHashCode(tab) + "";
    }

    private /* synthetic */ void lambda$hookTabFolderSkin$5(Pane pane, Pane pane2, DragEvent dragEvent) {
        this.tabPane_handleDragDropped(pane, pane2, dragEvent);
    }

    private /* synthetic */ void lambda$hookTabFolderSkin$4(Pane pane, Pane pane2, DragEvent dragEvent) {
        this.tabPane_handleDragOver(pane, pane2, dragEvent);
    }

    static {
        TAB_MOVE = new DataFormat(new String[]{"DnDTabPane:tabMove"});
    }
}

