/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.tabpane;

import java.util.function.Consumer;
import java.util.function.Function;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.input.DragEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import org.eclipse.fx.ui.controls.markers.PositionMarker;
import org.eclipse.fx.ui.controls.markers.TabOutlineMarker;
import org.eclipse.fx.ui.controls.tabpane.DndTabPane;
import org.eclipse.fx.ui.controls.tabpane.skin.DnDTabPaneSkin;

public final class DndTabPaneFactory {
    private static MarkerFeedback CURRENT_FEEDBACK;

    private DndTabPaneFactory() {
    }

    public static DndTabPane createDndTabPane(final Consumer<DragSetup> consumer) {
        return new DndTabPane(){

            protected Skin<?> createDefaultSkin() {
                DnDTabPaneSkin dnDTabPaneSkin = new DnDTabPaneSkin(this);
                consumer.accept(dnDTabPaneSkin);
                return dnDTabPaneSkin;
            }
        };
    }

    public static Pane createDefaultDnDPane(final FeedbackType feedbackType, Consumer<TabPane> consumer) {
        final StackPane stackPane = new StackPane();
        DndTabPane dndTabPane = new DndTabPane(){

            protected Skin<?> createDefaultSkin() {
                DnDTabPaneSkin dnDTabPaneSkin = new DnDTabPaneSkin(this);
                DndTabPaneFactory.setup(feedbackType, (Pane)stackPane, dnDTabPaneSkin);
                return dnDTabPaneSkin;
            }
        };
        if (consumer != null) {
            consumer.accept(dndTabPane);
        }
        stackPane.getChildren().add((Object)dndTabPane);
        return stackPane;
    }

    public static boolean hasDnDContent(DragEvent dragEvent) {
        return dragEvent.getDragboard().hasContent(DnDTabPaneSkin.TAB_MOVE);
    }

    public static String getDnDContent(DragEvent dragEvent) {
        return (String)dragEvent.getDragboard().getContent(DnDTabPaneSkin.TAB_MOVE);
    }

    public static void setup(FeedbackType feedbackType, Pane pane, DragSetup dragSetup) {
        dragSetup.setStartFunction(tab -> !tab.isDisabled() && ((DndTabPane)tab.getTabPane()).isDraggingEnabled());
        dragSetup.setFeedbackConsumer(feedbackData -> DndTabPaneFactory.handleFeedback(feedbackType, pane, feedbackData));
        dragSetup.setDropConsumer(DndTabPaneFactory::handleDropped);
        dragSetup.setDragFinishedConsumer(DndTabPaneFactory::handleFinished);
    }

    private static void fireTabDraggedEvent(DndTabPane dndTabPane, Tab tab, int n, int n2) {
        dndTabPane.fireTabDragged(tab, n, n2);
    }

    private static void handleDropped(DroppedData droppedData) {
        TabPane tabPane = droppedData.targetTab.getTabPane();
        int n = droppedData.draggedTab.getTabPane().getTabs().indexOf((Object)droppedData.draggedTab);
        droppedData.draggedTab.getTabPane().getTabs().remove((Object)droppedData.draggedTab);
        int n2 = tabPane.getTabs().indexOf((Object)droppedData.targetTab);
        if (droppedData.dropType == DropType.AFTER) {
            if (n2 + 1 <= tabPane.getTabs().size()) {
                tabPane.getTabs().add(n2 + 1, (Object)droppedData.draggedTab);
            } else {
                tabPane.getTabs().add((Object)droppedData.draggedTab);
            }
        } else {
            tabPane.getTabs().add(n2, (Object)droppedData.draggedTab);
        }
        DndTabPaneFactory.fireTabDraggedEvent((DndTabPane)tabPane, droppedData.draggedTab, n, tabPane.getTabs().indexOf((Object)droppedData.draggedTab));
        droppedData.draggedTab.getTabPane().getSelectionModel().select((Object)droppedData.draggedTab);
    }

    private static void handleFeedback(FeedbackType feedbackType, Pane pane, FeedbackData feedbackData) {
        if (feedbackData.dropType == DropType.NONE) {
            DndTabPaneFactory.cleanup();
            return;
        }
        MarkerFeedback markerFeedback = CURRENT_FEEDBACK;
        if (markerFeedback == null || !markerFeedback.data.equals(feedbackData)) {
            DndTabPaneFactory.cleanup();
            CURRENT_FEEDBACK = feedbackType == FeedbackType.MARKER ? DndTabPaneFactory.handleMarker(pane, feedbackData) : DndTabPaneFactory.handleOutline(pane, feedbackData);
        }
    }

    private static void handleFinished(Tab tab) {
        DndTabPaneFactory.cleanup();
    }

    static void cleanup() {
        if (CURRENT_FEEDBACK != null) {
            CURRENT_FEEDBACK.hide();
            CURRENT_FEEDBACK = null;
        }
    }

    private static MarkerFeedback handleMarker(Pane pane, FeedbackData feedbackData) {
        PositionMarker positionMarker = null;
        for (Node node : pane.getChildren()) {
            if (!(node instanceof PositionMarker)) continue;
            positionMarker = (PositionMarker)node;
        }
        if (positionMarker == null) {
            positionMarker = new PositionMarker();
            positionMarker.setManaged(false);
            pane.getChildren().add((Object)positionMarker);
        } else {
            positionMarker.setVisible(true);
        }
        double d = positionMarker.getBoundsInLocal().getWidth();
        double d2 = positionMarker.getBoundsInLocal().getHeight();
        double d3 = feedbackData.bounds.getHeight() / d2;
        positionMarker.setScaleX(d3 += 0.1);
        positionMarker.setScaleY(d3);
        double d4 = d / 2.0;
        double d5 = (d2 - d2 * d3) / 2.0;
        if (feedbackData.dropType == DropType.AFTER) {
            positionMarker.relocate(feedbackData.bounds.getMinX() + feedbackData.bounds.getWidth() - d4, feedbackData.bounds.getMinY() - d5);
        } else {
            positionMarker.relocate(feedbackData.bounds.getMinX() - d4, feedbackData.bounds.getMinY() - d5);
        }
        final PositionMarker positionMarker2 = positionMarker;
        return new MarkerFeedback(feedbackData){

            @Override
            public void hide() {
                positionMarker2.setVisible(false);
            }
        };
    }

    private static MarkerFeedback handleOutline(Pane pane, FeedbackData feedbackData) {
        TabOutlineMarker tabOutlineMarker = null;
        for (Node node : pane.getChildren()) {
            if (!(node instanceof TabOutlineMarker)) continue;
            tabOutlineMarker = (TabOutlineMarker)node;
        }
        if (tabOutlineMarker == null) {
            tabOutlineMarker = new TabOutlineMarker(pane.getBoundsInLocal(), (Bounds)new BoundingBox(feedbackData.bounds.getMinX(), feedbackData.bounds.getMinY(), feedbackData.bounds.getWidth(), feedbackData.bounds.getHeight()), feedbackData.dropType == DropType.BEFORE);
            tabOutlineMarker.setManaged(false);
            tabOutlineMarker.setMouseTransparent(true);
            pane.getChildren().add((Object)tabOutlineMarker);
        } else {
            tabOutlineMarker.updateBounds(pane.getBoundsInLocal(), (Bounds)new BoundingBox(feedbackData.bounds.getMinX(), feedbackData.bounds.getMinY(), feedbackData.bounds.getWidth(), feedbackData.bounds.getHeight()), feedbackData.dropType == DropType.BEFORE);
            tabOutlineMarker.setVisible(true);
        }
        Object object = tabOutlineMarker;
        return new MarkerFeedback(feedbackData, (TabOutlineMarker)((Object)object)){
            final /* synthetic */ TabOutlineMarker val$fmarker;
            {
                this.val$fmarker = tabOutlineMarker;
                super(feedbackData);
            }

            @Override
            public void hide() {
                this.val$fmarker.setVisible(false);
            }
        };
    }

    public static interface DragSetup {
        public void setStartFunction(Function<Tab, Boolean> var1);

        public void setDragFinishedConsumer(Consumer<Tab> var1);

        public void setFeedbackConsumer(Consumer<FeedbackData> var1);

        public void setDropConsumer(Consumer<DroppedData> var1);

        public void setClipboardDataFunction(Function<Tab, String> var1);
    }

    public static class DroppedData {
        public final Tab draggedTab;
        public final Tab targetTab;
        public final DropType dropType;

        public DroppedData(Tab tab, Tab tab2, DropType dropType) {
            this.draggedTab = tab;
            this.targetTab = tab2;
            this.dropType = dropType;
        }
    }

    public static class FeedbackData {
        public final Tab draggedTab;
        public final Tab targetTab;
        public final Bounds bounds;
        public final DropType dropType;

        public FeedbackData(Tab tab, Tab tab2, Bounds bounds, DropType dropType) {
            this.draggedTab = tab;
            this.targetTab = tab2;
            this.bounds = bounds;
            this.dropType = dropType;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.bounds == null ? 0 : this.bounds.hashCode());
            n = 31 * n + this.draggedTab.hashCode();
            n = 31 * n + this.dropType.hashCode();
            n = 31 * n + (this.targetTab == null ? 0 : this.targetTab.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            FeedbackData feedbackData = (FeedbackData)object;
            if (this.bounds == null ? feedbackData.bounds != null : !this.bounds.equals(feedbackData.bounds)) {
                return false;
            }
            if (!this.draggedTab.equals(feedbackData.draggedTab)) {
                return false;
            }
            if (this.dropType != feedbackData.dropType) {
                return false;
            }
            return !(this.targetTab == null ? feedbackData.targetTab != null : !this.targetTab.equals(feedbackData.targetTab));
        }
    }

    public static enum FeedbackType {
        MARKER,
        OUTLINE;

    }

    public static enum DropType {
        NONE,
        BEFORE,
        AFTER;

    }

    private static abstract class MarkerFeedback {
        public final FeedbackData data;

        public MarkerFeedback(FeedbackData feedbackData) {
            this.data = feedbackData;
        }

        public abstract void hide();
    }
}

