/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.markers;

import com.sun.javafx.css.converters.PaintConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polyline;
import javafx.scene.shape.StrokeType;

public final class TabOutlineMarker
extends Group {
    private Bounds containerBounds;
    private Bounds referenceBounds;
    private boolean before;
    private final ObjectProperty<Paint> fill = new SimpleStyleableObjectProperty(FILL, (Object)this, "fill", (Object)Color.ORANGE);
    private static final CssMetaData<TabOutlineMarker, Paint> FILL = new CssMetaData<TabOutlineMarker, Paint>("-fx-fill", PaintConverter.getInstance(), (Paint)Color.ORANGE){

        public boolean isSettable(TabOutlineMarker tabOutlineMarker) {
            return !tabOutlineMarker.fillProperty().isBound();
        }

        public StyleableProperty<Paint> getStyleableProperty(TabOutlineMarker tabOutlineMarker) {
            return (StyleableProperty)tabOutlineMarker.fillProperty();
        }
    };
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

    public TabOutlineMarker(Bounds bounds, Bounds bounds2, boolean bl) {
        this.containerBounds = bounds;
        this.referenceBounds = bounds2;
        this.updateBounds(bounds, bounds2, bl);
        this.getStyleClass().add((Object)"tab-outline-marker");
    }

    public void updateBounds(Bounds bounds, Bounds bounds2, boolean bl) {
        if (bounds.equals(this.containerBounds) && bounds2.equals(this.referenceBounds) && bl == this.before) {
            return;
        }
        this.containerBounds = bounds;
        this.referenceBounds = bounds2;
        this.before = bl;
        Polyline polyline = new Polyline();
        Bounds bounds3 = bounds2;
        bounds3 = bl ? new BoundingBox(Math.max(0.0, bounds3.getMinX() - bounds3.getWidth() / 2.0), bounds3.getMinY(), bounds3.getWidth(), bounds3.getHeight()) : new BoundingBox(Math.max(0.0, bounds3.getMaxX() - bounds3.getWidth() / 2.0), bounds3.getMinY(), bounds3.getWidth(), bounds3.getHeight());
        polyline.getPoints().addAll((Object[])new Double[]{0.0, bounds3.getMaxY(), bounds3.getMinX(), bounds3.getMaxY(), bounds3.getMinX(), bounds3.getMinY(), bounds3.getMaxX(), bounds3.getMinY(), bounds3.getMaxX(), bounds3.getMaxY(), bounds.getMaxX(), bounds3.getMaxY(), bounds.getMaxX(), bounds.getMaxY(), bounds.getMinX(), bounds.getMaxY(), bounds.getMinX(), bounds3.getMaxY()});
        polyline.strokeProperty().bind(this.fillProperty());
        polyline.setStrokeWidth(3.0);
        polyline.setStrokeType(StrokeType.INSIDE);
        this.getChildren().setAll((Object[])new Node[]{polyline});
    }

    public ObjectProperty<Paint> fillProperty() {
        return this.fill;
    }

    public void setFill(Paint paint) {
        this.fillProperty().set((Object)paint);
    }

    public Paint getFill() {
        return (Paint)this.fillProperty().get();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return TabOutlineMarker.getClassCssMetaData();
    }

    static {
        ArrayList<CssMetaData<TabOutlineMarker, Paint>> arrayList = new ArrayList<CssMetaData<TabOutlineMarker, Paint>>(Group.getClassCssMetaData());
        arrayList.add(FILL);
        STYLEABLES = Collections.unmodifiableList(arrayList);
    }
}

