/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi.util.jsonmessage;

import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class JSONMessage {
    private static final BiMap<ChatColor, String> stylesToNames;
    private final List<MessagePart> parts = new ArrayList<MessagePart>();

    private JSONMessage(String text) {
        this.parts.add(new MessagePart(text));
    }

    public static JSONMessage create(String text) {
        return new JSONMessage(text);
    }

    public static JSONMessage create() {
        return JSONMessage.create("");
    }

    public static void actionbar(String message, Player ... players) {
        ReflectionHelper.sendPacket(ReflectionHelper.createActionbarPacket(ChatColor.translateAlternateColorCodes('&', message)), players);
    }

    public MessagePart last() {
        if (this.parts.size() <= 0) {
            throw new ArrayIndexOutOfBoundsException("No MessageParts exist!");
        }
        return this.parts.get(this.parts.size() - 1);
    }

    public JsonObject toJSON() {
        JsonObject obj = new JsonObject();
        obj.addProperty("text", "");
        JsonArray array = new JsonArray();
        for (MessagePart part : this.parts) {
            array.add(part.toJSON());
        }
        obj.add("extra", array);
        return obj;
    }

    public String toString() {
        return this.toJSON().toString();
    }

    public String toLegacy() {
        StringBuilder output = new StringBuilder();
        for (MessagePart part : this.parts) {
            output.append(part.toLegacy());
        }
        return output.toString();
    }

    public void send(Player ... players) {
        ReflectionHelper.sendPacket(ReflectionHelper.createTextPacket(this.toString()), players);
    }

    public void title(int fadeIn, int stay, int fadeOut, Player ... players) {
        ReflectionHelper.sendPacket(ReflectionHelper.createTitleTimesPacket(fadeIn, stay, fadeOut), players);
        ReflectionHelper.sendPacket(ReflectionHelper.createTitlePacket(this.toString()), players);
    }

    public void subtitle(Player ... players) {
        ReflectionHelper.sendPacket(ReflectionHelper.createSubtitlePacket(this.toString()), players);
    }

    public void actionbar(Player ... players) {
        JSONMessage.actionbar(this.toLegacy(), players);
    }

    public JSONMessage color(ChatColor color) {
        this.last().setColor(color);
        return this;
    }

    public JSONMessage style(ChatColor style) {
        this.last().addStyle(style);
        return this;
    }

    public JSONMessage runCommand(String command) {
        this.last().setOnClick(ClickEvent.runCommand(command));
        return this;
    }

    public JSONMessage suggestCommand(String command) {
        this.last().setOnClick(ClickEvent.suggestCommand(command));
        return this;
    }

    public JSONMessage openURL(String url) {
        this.last().setOnClick(ClickEvent.openURL(url));
        return this;
    }

    public JSONMessage changePage(int page) {
        this.last().setOnClick(ClickEvent.changePage(page));
        return this;
    }

    public JSONMessage tooltip(String text) {
        this.last().setOnHover(HoverEvent.showText(text));
        return this;
    }

    public JSONMessage tooltip(JSONMessage message) {
        this.last().setOnHover(HoverEvent.showText(message));
        return this;
    }

    public JSONMessage achievement(String id) {
        this.last().setOnHover(HoverEvent.showAchievement(id));
        return this;
    }

    public JSONMessage then(String text) {
        return this.then(new MessagePart(text));
    }

    public JSONMessage then(MessagePart nextPart) {
        this.parts.add(nextPart);
        return this;
    }

    public JSONMessage bar(int length) {
        return this.then(Strings.repeat("-", length)).color(ChatColor.DARK_GRAY).style(ChatColor.STRIKETHROUGH);
    }

    public JSONMessage bar() {
        return this.bar(53);
    }

    public JSONMessage newline() {
        return this.then("\n");
    }

    static {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        for (ChatColor style : ChatColor.values()) {
            String styleName;
            if (!style.isFormat()) continue;
            switch (style) {
                case MAGIC: {
                    styleName = "obfuscated";
                    break;
                }
                case UNDERLINE: {
                    styleName = "underlined";
                    break;
                }
                default: {
                    styleName = style.name().toLowerCase();
                }
            }
            builder.put((Object)style, styleName);
        }
        stylesToNames = builder.build();
    }

    public class MessagePart {
        private final List<ChatColor> styles = new ArrayList<ChatColor>();
        private MessageEvent onClick;
        private MessageEvent onHover;
        private ChatColor color;
        private String text;

        public MessagePart(String text) {
            this.text = text == null ? "null" : text;
        }

        public JsonObject toJSON() {
            Objects.requireNonNull(this.text);
            JsonObject obj = new JsonObject();
            obj.addProperty("text", this.text);
            if (this.color != null) {
                obj.addProperty("color", this.color.name().toLowerCase());
            }
            for (ChatColor style : this.styles) {
                obj.addProperty((String)stylesToNames.get((Object)style), true);
            }
            if (this.onClick != null) {
                obj.add("clickEvent", this.onClick.toJSON());
            }
            if (this.onHover != null) {
                obj.add("hoverEvent", this.onHover.toJSON());
            }
            return obj;
        }

        public String toLegacy() {
            StringBuilder output = new StringBuilder();
            if (this.color != null) {
                output.append(this.color.toString());
            }
            for (ChatColor style : this.styles) {
                output.append(style.toString());
            }
            return output.append(this.text).toString();
        }

        public MessageEvent getOnClick() {
            return this.onClick;
        }

        public void setOnClick(MessageEvent onClick) {
            this.onClick = onClick;
        }

        public MessageEvent getOnHover() {
            return this.onHover;
        }

        public void setOnHover(MessageEvent onHover) {
            this.onHover = onHover;
        }

        public ChatColor getColor() {
            return this.color;
        }

        public void setColor(ChatColor color) {
            if (!color.isColor()) {
                throw new IllegalArgumentException(color.name() + " is not a color!");
            }
            this.color = color;
        }

        public List<ChatColor> getStyles() {
            return this.styles;
        }

        public void addStyle(ChatColor style) {
            if (style == null) {
                throw new IllegalArgumentException("Style cannot be null!");
            }
            if (!style.isFormat()) {
                throw new IllegalArgumentException(this.color.name() + " is not a style!");
            }
            this.styles.add(style);
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }
    }

    private static class ReflectionHelper {
        private static final String version;
        private static Class<?> craftPlayer;
        private static Constructor<?> chatComponentText;
        private static Class<?> packetPlayOutChat;
        private static Class<?> packetPlayOutTitle;
        private static Class<?> iChatBaseComponent;
        private static Class<?> titleAction;
        private static Field connection;
        private static MethodHandle GET_HANDLE;
        private static MethodHandle SEND_PACKET;
        private static MethodHandle STRING_TO_CHAT;
        private static Object enumActionTitle;
        private static Object enumActionSubtitle;
        private static Object enumChatMessage;
        private static Object enumActionbarMessage;
        private static boolean SETUP;
        private static int MAJOR_VER;

        private ReflectionHelper() {
        }

        static void sendPacket(Object packet, Player ... players) {
            if (!SETUP) {
                throw new IllegalStateException("ReflectionHelper is not set up!");
            }
            if (packet == null) {
                return;
            }
            for (Player player : players) {
                try {
                    SEND_PACKET.bindTo(connection.get(GET_HANDLE.bindTo(player).invoke())).invoke(packet);
                }
                catch (Throwable e) {
                    System.err.println("Failed to send packet");
                    e.printStackTrace();
                }
            }
        }

        private static void setType(Object object, byte type) {
            block5: {
                block4: {
                    if (MAJOR_VER < 12) break block4;
                    switch (type) {
                        case 1: {
                            ReflectionHelper.set("b", object, enumChatMessage);
                            break block5;
                        }
                        case 2: {
                            ReflectionHelper.set("b", object, enumActionbarMessage);
                            break block5;
                        }
                        default: {
                            throw new IllegalArgumentException("type must be 1 or 2");
                        }
                    }
                }
                ReflectionHelper.set("b", object, type);
            }
        }

        static Object createActionbarPacket(String message) {
            if (!SETUP) {
                throw new IllegalStateException("ReflectionHelper is not set up!");
            }
            Object packet = ReflectionHelper.createTextPacket(message);
            ReflectionHelper.setType(packet, (byte)2);
            return packet;
        }

        static Object createTextPacket(String message) {
            if (!SETUP) {
                throw new IllegalStateException("ReflectionHelper is not set up!");
            }
            try {
                Object packet = packetPlayOutChat.newInstance();
                ReflectionHelper.set("a", packet, ReflectionHelper.fromJson(message));
                ReflectionHelper.setType(packet, (byte)1);
                return packet;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        static Object createTitlePacket(String message) {
            if (!SETUP) {
                throw new IllegalStateException("ReflectionHelper is not set up!");
            }
            try {
                return packetPlayOutTitle.getConstructor(titleAction, iChatBaseComponent).newInstance(enumActionTitle, ReflectionHelper.fromJson(message));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        static Object createSubtitlePacket(String message) {
            if (!SETUP) {
                throw new IllegalStateException("ReflectionHelper is not set up!");
            }
            try {
                return packetPlayOutTitle.getConstructor(titleAction, iChatBaseComponent).newInstance(enumActionSubtitle, ReflectionHelper.fromJson(message));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        static Object createTitleTimesPacket(int fadeIn, int stay, int fadeOut) {
            if (!SETUP) {
                throw new IllegalStateException("ReflectionHelper is not set up!");
            }
            try {
                return packetPlayOutTitle.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(fadeIn, stay, fadeOut);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        static Object componentText(String message) {
            if (!SETUP) {
                throw new IllegalStateException("ReflectionHelper is not set up!");
            }
            try {
                return chatComponentText.newInstance(message);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        static Object fromJson(String json) {
            if (!SETUP) {
                throw new IllegalStateException("ReflectionHelper is not set up!");
            }
            if (!json.trim().startsWith("{")) {
                return ReflectionHelper.componentText(json);
            }
            try {
                return STRING_TO_CHAT.invoke(json);
            }
            catch (Throwable e) {
                e.printStackTrace();
                return null;
            }
        }

        static Class<?> getClass(String path) throws ClassNotFoundException {
            if (!SETUP) {
                throw new IllegalStateException("ReflectionHelper is not set up!");
            }
            return Class.forName(path.replace("{nms}", "net.minecraft.server." + version).replace("{obc}", "org.bukkit.craftbukkit." + version));
        }

        static void set(String field, Object obj, Object value) {
            try {
                Field f = obj.getClass().getDeclaredField(field);
                f.setAccessible(true);
                f.set(obj, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        static int getVersion() {
            if (!SETUP) {
                throw new IllegalStateException("ReflectionHelper is not set up!");
            }
            try {
                return Integer.parseInt(version.split("_")[1]);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                return 10;
            }
        }

        static {
            MAJOR_VER = -1;
            String[] split = Bukkit.getServer().getClass().getPackage().getName().split("\\.");
            version = split[split.length - 1];
            try {
                SETUP = true;
                MAJOR_VER = ReflectionHelper.getVersion();
                craftPlayer = ReflectionHelper.getClass("{obc}.entity.CraftPlayer");
                Method getHandle = craftPlayer.getMethod("getHandle", new Class[0]);
                connection = getHandle.getReturnType().getField("playerConnection");
                Method sendPacket = connection.getType().getMethod("sendPacket", ReflectionHelper.getClass("{nms}.Packet"));
                chatComponentText = ReflectionHelper.getClass("{nms}.ChatComponentText").getConstructor(String.class);
                iChatBaseComponent = ReflectionHelper.getClass("{nms}.IChatBaseComponent");
                Method stringToChat = MAJOR_VER < 8 ? ReflectionHelper.getClass("{nms}.ChatSerializer").getMethod("a", String.class) : ReflectionHelper.getClass("{nms}.IChatBaseComponent$ChatSerializer").getMethod("a", String.class);
                GET_HANDLE = MethodHandles.lookup().unreflect(getHandle);
                SEND_PACKET = MethodHandles.lookup().unreflect(sendPacket);
                STRING_TO_CHAT = MethodHandles.lookup().unreflect(stringToChat);
                packetPlayOutChat = ReflectionHelper.getClass("{nms}.PacketPlayOutChat");
                packetPlayOutTitle = ReflectionHelper.getClass("{nms}.PacketPlayOutTitle");
                titleAction = ReflectionHelper.getClass("{nms}.PacketPlayOutTitle$EnumTitleAction");
                enumActionTitle = titleAction.getField("TITLE").get(null);
                enumActionSubtitle = titleAction.getField("SUBTITLE").get(null);
                if (MAJOR_VER >= 12) {
                    Method getChatMessageType = ReflectionHelper.getClass("{nms}.ChatMessageType").getMethod("a", Byte.TYPE);
                    enumChatMessage = getChatMessageType.invoke(null, (byte)1);
                    enumActionbarMessage = getChatMessageType.invoke(null, (byte)2);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                SETUP = false;
            }
        }
    }

    public static class HoverEvent {
        public static MessageEvent showText(String text) {
            return new MessageEvent("show_text", text);
        }

        public static MessageEvent showText(JSONMessage message) {
            JsonArray arr = new JsonArray();
            arr.add(new JsonPrimitive(""));
            arr.add(message.toJSON());
            return new MessageEvent("show_text", arr);
        }

        public static MessageEvent showAchievement(String id) {
            return new MessageEvent("show_achievement", id);
        }
    }

    public static class ClickEvent {
        public static MessageEvent runCommand(String command) {
            return new MessageEvent("run_command", command);
        }

        public static MessageEvent suggestCommand(String command) {
            return new MessageEvent("suggest_command", command);
        }

        public static MessageEvent openURL(String url) {
            return new MessageEvent("open_url", url);
        }

        public static MessageEvent changePage(int page) {
            return new MessageEvent("change_page", page);
        }
    }

    public static class MessageEvent {
        private String action;
        private Object value;

        public MessageEvent(String action, Object value) {
            this.action = action;
            this.value = value;
        }

        public JsonObject toJSON() {
            JsonObject obj = new JsonObject();
            obj.addProperty("action", this.action);
            if (this.value instanceof JsonElement) {
                obj.add("value", (JsonElement)this.value);
            } else {
                obj.addProperty("value", this.value.toString());
            }
            return obj;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }
}

