/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi.util;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import me.clip.placeholderapi.PlaceholderAPIPlugin;

public class FileUtil {
    public static List<Class<?>> getClasses(String folder, Class<?> type) {
        return FileUtil.getClasses(folder, null, type);
    }

    public static List<Class<?>> getClasses(String folder, String fileName, Class<?> type) {
        List<Class<?>> list = new ArrayList();
        try {
            File f = new File(PlaceholderAPIPlugin.getInstance().getDataFolder(), folder);
            if (!f.exists()) {
                return list;
            }
            FilenameFilter fileNameFilter = (dir, name) -> {
                if (fileName != null) {
                    return name.endsWith(".jar") && name.replace(".jar", "").equalsIgnoreCase(fileName.replace(".jar", ""));
                }
                return name.endsWith(".jar");
            };
            File[] jars = f.listFiles(fileNameFilter);
            if (jars == null) {
                return list;
            }
            for (File file : jars) {
                list = FileUtil.gather(file.toURI().toURL(), list, type);
            }
            return list;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static List<Class<?>> gather(URL jar, List<Class<?>> list, Class<?> clazz) {
        if (list == null) {
            list = new ArrayList();
        }
        try (URLClassLoader cl = new URLClassLoader(new URL[]{jar}, clazz.getClassLoader());
             JarInputStream jis = new JarInputStream(jar.openStream());){
            JarEntry j;
            while ((j = jis.getNextJarEntry()) != null) {
                String cname;
                Class<?> c;
                String name = j.getName();
                if (name == null || name.isEmpty() || !name.endsWith(".class") || !clazz.isAssignableFrom(c = cl.loadClass(cname = (name = name.replace("/", ".")).substring(0, name.lastIndexOf(".class"))))) continue;
                list.add(c);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return list;
    }
}

