/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi.expansion.cloud;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.clip.placeholderapi.expansion.cloud.CloudExpansion;
import me.clip.placeholderapi.util.Msg;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ExpansionCloudManager {
    private static final String API_URL = "http://api.extendedclip.com/v2/";
    private static final Gson GSON = new Gson();
    private final PlaceholderAPIPlugin plugin;
    private final File expansionsDir;
    private final List<String> downloading = new ArrayList<String>();
    private final Map<Integer, CloudExpansion> remote = new TreeMap<Integer, CloudExpansion>();

    public ExpansionCloudManager(PlaceholderAPIPlugin plugin) {
        this.plugin = plugin;
        this.expansionsDir = new File(plugin.getDataFolder(), "expansions");
        boolean result = this.expansionsDir.mkdirs();
        if (result) {
            plugin.getLogger().info("Created Expansions Directory");
        }
    }

    public void clean() {
        this.remote.clear();
        this.downloading.clear();
    }

    public Map<Integer, CloudExpansion> getCloudExpansions() {
        return this.remote;
    }

    public CloudExpansion getCloudExpansion(String name) {
        return this.remote.values().stream().filter(ex -> ex.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public int getCloudAuthorCount() {
        return this.remote.values().stream().collect(Collectors.groupingBy(CloudExpansion::getAuthor, Collectors.counting())).size();
    }

    public int getToUpdateCount() {
        return (int)PlaceholderAPI.getExpansions().stream().filter(ex -> this.getCloudExpansion(ex.getName()) != null && this.getCloudExpansion(ex.getName()).shouldUpdate()).count();
    }

    public Map<Integer, CloudExpansion> getAllByAuthor(String author) {
        if (this.remote.isEmpty()) {
            return new HashMap<Integer, CloudExpansion>();
        }
        TreeMap<Integer, CloudExpansion> byAuthor = new TreeMap<Integer, CloudExpansion>();
        for (CloudExpansion ex : this.remote.values()) {
            if (!ex.getAuthor().equalsIgnoreCase(author)) continue;
            byAuthor.put(byAuthor.size(), ex);
        }
        return byAuthor;
    }

    public Map<Integer, CloudExpansion> getAllInstalled() {
        if (this.remote.isEmpty()) {
            return new HashMap<Integer, CloudExpansion>();
        }
        TreeMap<Integer, CloudExpansion> has = new TreeMap<Integer, CloudExpansion>();
        for (CloudExpansion ex : this.remote.values()) {
            if (!ex.hasExpansion()) continue;
            has.put(has.size(), ex);
        }
        return has;
    }

    public int getPagesAvailable(Map<Integer, CloudExpansion> map, int amount) {
        int pages;
        if (map == null) {
            return 0;
        }
        int n = pages = map.size() > 0 ? 1 : 0;
        if (pages == 0) {
            return pages;
        }
        if (map.size() > amount) {
            pages = map.size() / amount;
            if (map.size() % amount > 0) {
                ++pages;
            }
        }
        return pages;
    }

    public Map<Integer, CloudExpansion> getPage(Map<Integer, CloudExpansion> map, int page, int size) {
        if (map == null || map.size() == 0 || page > this.getPagesAvailable(map, size)) {
            return new HashMap<Integer, CloudExpansion>();
        }
        int end = size * page;
        int start = end - size;
        TreeMap<Integer, CloudExpansion> ex = new TreeMap<Integer, CloudExpansion>();
        IntStream.range(start, end).forEach(n -> {
            CloudExpansion cfr_ignored_0 = (CloudExpansion)ex.put(n, (CloudExpansion)map.get(n));
        });
        return ex;
    }

    public void fetch(boolean allowUnverified) {
        this.plugin.getLogger().info("Fetching available expansion information...");
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            HashMap<String, CloudExpansion> data = new HashMap<String, CloudExpansion>();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(new URL(API_URL).openStream()));){
                data.putAll((Map)GSON.fromJson((Reader)reader, new TypeToken<Map<String, CloudExpansion>>(){}.getType()));
            }
            catch (Exception ex) {
                if (this.plugin.getPlaceholderAPIConfig().isDebugMode()) {
                    ex.printStackTrace();
                }
                this.plugin.getLogger().warning("Unable to fetch expansions!\nThere was an error with the server host connecting to the PlaceholderAPI eCloud (https://api.extendedclip.com/v2/)");
            }
            ArrayList<CloudExpansion> unsorted = new ArrayList<CloudExpansion>();
            data.forEach((name, cexp) -> {
                if ((allowUnverified || cexp.isVerified()) && cexp.getLatestVersion() != null && cexp.getVersion(cexp.getLatestVersion()) != null) {
                    cexp.setName((String)name);
                    PlaceholderExpansion ex = this.plugin.getExpansionManager().getRegisteredExpansion(cexp.getName());
                    if (ex != null && ex.isRegistered()) {
                        cexp.setHasExpansion(true);
                        if (!ex.getVersion().equals(cexp.getLatestVersion())) {
                            cexp.setShouldUpdate(true);
                        }
                    }
                    unsorted.add((CloudExpansion)cexp);
                }
            });
            unsorted.sort(Comparator.comparing(CloudExpansion::getLastUpdate).reversed());
            int count = 0;
            for (CloudExpansion e : unsorted) {
                this.remote.put(count++, e);
            }
            this.plugin.getLogger().info(count + " placeholder expansions are available on the cloud.");
            long updates = this.getToUpdateCount();
            if (updates > 0L) {
                this.plugin.getLogger().info(updates + " installed expansions have updates available.");
            }
        });
    }

    public boolean isDownloading(String expansion) {
        return this.downloading.contains(expansion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download(URL url, String name) throws IOException {
        InputStream is = null;
        FileOutputStream fos = null;
        try {
            int l;
            URLConnection urlConn = url.openConnection();
            is = urlConn.getInputStream();
            fos = new FileOutputStream(this.expansionsDir.getAbsolutePath() + File.separator + "Expansion-" + name + ".jar");
            byte[] buffer = new byte[is.available()];
            while ((l = is.read(buffer)) > 0) {
                fos.write(buffer, 0, l);
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            finally {
                if (fos != null) {
                    fos.close();
                }
            }
        }
    }

    public void downloadExpansion(String player, CloudExpansion ex) {
        this.downloadExpansion(player, ex, ex.getLatestVersion());
    }

    public void downloadExpansion(String player, CloudExpansion ex, String version) {
        if (this.downloading.contains(ex.getName())) {
            return;
        }
        CloudExpansion.Version ver = ex.getVersions().stream().filter(v -> v.getVersion().equals(version)).findFirst().orElse(null);
        if (ver == null) {
            return;
        }
        this.downloading.add(ex.getName());
        this.plugin.getLogger().info("Attempting download of expansion: " + ex.getName() + (player != null ? " by user: " + player : "") + " from url: " + ver.getUrl());
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                this.download(new URL(ver.getUrl()), ex.getName());
                this.plugin.getLogger().info("Download of expansion: " + ex.getName() + " complete!");
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to download expansion: " + ex.getName() + " from: " + ver.getUrl());
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    Player p;
                    this.downloading.remove(ex.getName());
                    if (player != null && (p = Bukkit.getPlayer(player)) != null) {
                        Msg.msg(p, "&cThere was a problem downloading expansion: &f" + ex.getName());
                    }
                });
                return;
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                Player p;
                this.downloading.remove(ex.getName());
                if (player != null && (p = Bukkit.getPlayer(player)) != null) {
                    Msg.msg(p, "&aExpansion &f" + ex.getName() + " &adownload complete!");
                    Msg.msg(p, "&aMake sure to run &f/papi reload &ato enable it!");
                }
            });
        });
    }
}

