/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi.expansion;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.PlaceholderHook;
import me.clip.placeholderapi.expansion.Configurable;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.clip.placeholderapi.expansion.Taskable;
import me.clip.placeholderapi.expansion.VersionSpecific;
import me.clip.placeholderapi.expansion.cloud.CloudExpansion;
import me.clip.placeholderapi.util.FileUtil;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;

public final class ExpansionManager {
    private final PlaceholderAPIPlugin plugin;

    public ExpansionManager(PlaceholderAPIPlugin instance) {
        this.plugin = instance;
        File f = new File(PlaceholderAPIPlugin.getInstance().getDataFolder(), "expansions");
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    public PlaceholderExpansion getRegisteredExpansion(String name) {
        for (Map.Entry<String, PlaceholderHook> hook : PlaceholderAPI.getPlaceholders().entrySet()) {
            if (!(hook.getValue() instanceof PlaceholderExpansion) || !name.equalsIgnoreCase(hook.getKey())) continue;
            return (PlaceholderExpansion)hook.getValue();
        }
        return null;
    }

    public boolean registerExpansion(PlaceholderExpansion expansion) {
        CloudExpansion ce;
        VersionSpecific nms;
        if (expansion == null || expansion.getIdentifier() == null) {
            return false;
        }
        if (expansion instanceof Configurable) {
            Map<String, Object> defaults = ((Configurable)((Object)expansion)).getDefaults();
            String pre = "expansions." + expansion.getIdentifier() + ".";
            FileConfiguration cfg = this.plugin.getConfig();
            boolean save = false;
            if (defaults != null) {
                for (Map.Entry<String, Object> entries : defaults.entrySet()) {
                    if (entries.getKey() == null || entries.getKey().isEmpty()) continue;
                    if (entries.getValue() == null) {
                        if (!cfg.contains(pre + entries.getKey())) continue;
                        save = true;
                        cfg.set(pre + entries.getKey(), null);
                        continue;
                    }
                    if (cfg.contains(pre + entries.getKey())) continue;
                    save = true;
                    cfg.set(pre + entries.getKey(), entries.getValue());
                }
            }
            if (save) {
                this.plugin.saveConfig();
                this.plugin.reloadConfig();
            }
        }
        if (expansion instanceof VersionSpecific && !(nms = (VersionSpecific)((Object)expansion)).isCompatibleWith(PlaceholderAPIPlugin.getServerVersion())) {
            this.plugin.getLogger().info("Your server version is not compatible with expansion: " + expansion.getIdentifier() + " version: " + expansion.getVersion());
            return false;
        }
        if (!expansion.canRegister()) {
            return false;
        }
        if (!expansion.register()) {
            return false;
        }
        if (expansion instanceof Listener) {
            Listener l = (Listener)((Object)expansion);
            Bukkit.getPluginManager().registerEvents(l, this.plugin);
        }
        this.plugin.getLogger().info("Successfully registered expansion: " + expansion.getIdentifier());
        if (expansion instanceof Taskable) {
            ((Taskable)((Object)expansion)).start();
        }
        if (this.plugin.getExpansionCloud() != null && (ce = this.plugin.getExpansionCloud().getCloudExpansion(expansion.getIdentifier())) != null) {
            ce.setHasExpansion(true);
            if (!ce.getLatestVersion().equals(expansion.getVersion())) {
                ce.setShouldUpdate(true);
            }
        }
        return true;
    }

    public PlaceholderExpansion registerExpansion(String fileName) {
        List<Class<?>> subs = FileUtil.getClasses("expansions", fileName, PlaceholderExpansion.class);
        if (subs == null || subs.isEmpty()) {
            return null;
        }
        PlaceholderExpansion ex = this.createInstance(subs.get(0));
        if (this.registerExpansion(ex)) {
            return ex;
        }
        return null;
    }

    public void registerAllExpansions() {
        if (this.plugin == null) {
            return;
        }
        List<Class<?>> subs = FileUtil.getClasses("expansions", null, PlaceholderExpansion.class);
        if (subs == null || subs.isEmpty()) {
            return;
        }
        for (Class<?> klass : subs) {
            PlaceholderExpansion ex = this.createInstance(klass);
            if (ex == null) continue;
            this.registerExpansion(ex);
        }
    }

    private PlaceholderExpansion createInstance(Class<?> klass) {
        PlaceholderExpansion ex;
        block6: {
            if (klass == null) {
                return null;
            }
            ex = null;
            if (!PlaceholderExpansion.class.isAssignableFrom(klass)) {
                return null;
            }
            try {
                Constructor<?>[] c = klass.getConstructors();
                if (c.length == 0) {
                    ex = (PlaceholderExpansion)klass.newInstance();
                    break block6;
                }
                for (Constructor<?> con : c) {
                    if (con.getParameterTypes().length != 0) continue;
                    ex = (PlaceholderExpansion)klass.newInstance();
                    break;
                }
            }
            catch (Throwable t) {
                this.plugin.getLogger().severe("Failed to init placeholder expansion from class: " + klass.getName());
                this.plugin.getLogger().severe(t.getMessage());
            }
        }
        return ex;
    }
}

