/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi.commands;

import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.commands.ExpansionCloudCommands;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.clip.placeholderapi.util.Msg;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PlaceholderAPICommands
implements CommandExecutor {
    private final PlaceholderAPIPlugin plugin;
    private final CommandExecutor eCloud;

    public PlaceholderAPICommands(PlaceholderAPIPlugin i) {
        this.plugin = i;
        this.eCloud = new ExpansionCloudCommands(i);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onCommand(CommandSender s, Command c, String label, String[] args) {
        if (args.length == 0) {
            Msg.msg(s, "PlaceholderAPI &7version &b&o" + this.plugin.getDescription().getVersion(), "&fCreated by&7: &b" + this.plugin.getDescription().getAuthors(), "&fPapi commands: &b/papi help", "&fEcloud commands: &b/papi ecloud");
            return true;
        }
        if (args[0].equalsIgnoreCase("help")) {
            Msg.msg(s, "PlaceholderAPI &aHelp &e(&f" + this.plugin.getDescription().getVersion() + "&e)", "&b/papi", "&fView plugin info/version info", "&b/papi list", "&fList all placeholder expansions that are currently active", "&b/papi info <placeholder name>", "&fView information for a specific expansion", "&b/papi parse <(playername)/me> <...args>", "&fParse a String with placeholders", "&b/papi bcparse <(playername)/me> <...args>", "&fParse a String with placeholders and broadcast the message", "&b/papi parserel <player one> <player two> <...args>", "&fParse a String with relational placeholders", "&b/papi register <fileName>", "&fRegister an expansion by the name of the file", "&b/papi unregister <Expansion name>", "&fUnregister an expansion by name", "&b/papi reload", "&fReload the config settings");
            if (!s.hasPermission("placeholderapi.ecloud")) return true;
            if (this.plugin.getExpansionCloud() == null) {
                Msg.msg(s, "&b/papi enablecloud", "&fEnable the expansion cloud");
                return true;
            }
            Msg.msg(s, "&b/papi disablecloud", "&fDisable the expansion cloud", "&b/papi ecloud", "&fView ecloud command usage");
            return true;
        }
        if (args[0].equalsIgnoreCase("ecloud")) {
            if (!s.hasPermission("placeholderapi.ecloud")) {
                Msg.msg(s, "&cYou don't have permission to do that!");
                return true;
            }
            if (this.plugin.getExpansionCloud() != null) return this.eCloud.onCommand(s, c, label, args);
            Msg.msg(s, "&7The expansion cloud is not enabled!");
            return true;
        }
        if (args[0].equalsIgnoreCase("enablecloud")) {
            if (!s.hasPermission("placeholderapi.ecloud")) {
                Msg.msg(s, "&cYou don't have permission to do that!");
                return true;
            }
            if (this.plugin.getExpansionCloud() != null) {
                Msg.msg(s, "&7The cloud is already enabled!");
                return true;
            }
            this.plugin.enableCloud();
            this.plugin.getPlaceholderAPIConfig().setCloudEnabled(true);
            Msg.msg(s, "&aThe cloud has been enabled!");
            return true;
        }
        if (args[0].equalsIgnoreCase("disablecloud")) {
            if (!s.hasPermission("placeholderapi.ecloud")) {
                Msg.msg(s, "&cYou don't have permission to do that!");
                return true;
            }
            if (this.plugin.getExpansionCloud() == null) {
                Msg.msg(s, "&7The cloud is already disabled!");
                return true;
            }
            this.plugin.disableCloud();
            this.plugin.getPlaceholderAPIConfig().setCloudEnabled(false);
            Msg.msg(s, "&aThe cloud has been disabled!");
            return true;
        }
        if (args.length > 1 && args[0].equalsIgnoreCase("info")) {
            if (!s.hasPermission("placeholderapi.info")) {
                Msg.msg(s, "&cYou don't have permission to do that!");
                return true;
            }
            PlaceholderExpansion placeholderExpansion = this.plugin.getExpansionManager().getRegisteredExpansion(args[1]);
            if (placeholderExpansion == null) {
                Msg.msg(s, "&cThere is no expansion loaded with the identifier: &f" + args[1]);
                return true;
            }
            Msg.msg(s, "&7Placeholder expansion info for: &f" + placeholderExpansion.getName());
            Msg.msg(s, "&7Status: " + (placeholderExpansion.isRegistered() ? "&aRegistered" : "&cNot registered"));
            if (placeholderExpansion.getAuthor() != null) {
                Msg.msg(s, "&7Created by: &f" + placeholderExpansion.getAuthor());
            }
            if (placeholderExpansion.getVersion() != null) {
                Msg.msg(s, "&7Version: &f" + placeholderExpansion.getVersion());
            }
            if (placeholderExpansion.getRequiredPlugin() != null) {
                Msg.msg(s, "&7Requires plugin: &f" + placeholderExpansion.getRequiredPlugin());
            }
            if (placeholderExpansion.getPlaceholders() == null) return true;
            Msg.msg(s, "&8&m-- &r&7Placeholders &8&m--");
            Iterator<String> iterator = placeholderExpansion.getPlaceholders().iterator();
            while (iterator.hasNext()) {
                String placeholder = iterator.next();
                Msg.msg(s, placeholder);
            }
            return true;
        }
        if (args.length > 2 && args[0].equalsIgnoreCase("parse") || args.length > 2 && args[0].equalsIgnoreCase("bcparse")) {
            void var5_9;
            if (!s.hasPermission("placeholderapi.parse")) {
                Msg.msg(s, "&cYou don't have permission to do that!");
                return true;
            }
            if (args[1].equalsIgnoreCase("me")) {
                if (!(s instanceof Player)) {
                    Msg.msg(s, "&cThis command must target a player when used by console");
                    return true;
                }
                Player player = (Player)s;
            } else if (Bukkit.getPlayer(args[1]) != null) {
                Player player = Bukkit.getPlayer(args[1]);
            } else {
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer(args[1]);
            }
            if (var5_9 == null || !var5_9.hasPlayedBefore()) {
                Msg.msg(s, "&cFailed to find player: &f" + args[1]);
                return true;
            }
            String parse = StringUtils.join((Object[])args, " ", 2, args.length);
            if (args[0].equalsIgnoreCase("bcparse")) {
                Msg.broadcast("&r" + PlaceholderAPI.setPlaceholders((OfflinePlayer)var5_9, parse));
                return true;
            }
            Msg.msg(s, "&r" + PlaceholderAPI.setPlaceholders((OfflinePlayer)var5_9, parse));
            return true;
        }
        if (args.length > 3 && args[0].equalsIgnoreCase("parserel")) {
            if (!(s instanceof Player)) {
                Msg.msg(s, "&cThis command can only be used in game!");
                return true;
            }
            if (!s.hasPermission("placeholderapi.parse")) {
                Msg.msg(s, "&cYou don't have permission to do that!");
                return true;
            }
            Player player = Bukkit.getPlayer(args[1]);
            if (player == null) {
                Msg.msg(s, args[1] + " &cis not online!");
                return true;
            }
            Player two = Bukkit.getPlayer(args[2]);
            if (two == null) {
                Msg.msg(s, args[2] + " &cis not online!");
                return true;
            }
            String parse = StringUtils.join((Object[])args, " ", 3, args.length);
            Msg.msg(s, "&r" + PlaceholderAPI.setRelationalPlaceholders(player, two, parse));
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            if (s instanceof Player && !s.hasPermission("placeholderapi.reload")) {
                Msg.msg(s, "&cYou don't have permission to do that!");
                return true;
            }
            Msg.msg(s, "&fPlaceholder&7API &bconfiguration reloaded!");
            this.plugin.reloadConf(s);
            return true;
        }
        if (args[0].equalsIgnoreCase("list")) {
            if (s instanceof Player && !s.hasPermission("placeholderapi.list")) {
                Msg.msg(s, "&cYou don't have permission to do that!");
                return true;
            }
            Set<String> set = PlaceholderAPI.getRegisteredIdentifiers();
            if (set.isEmpty()) {
                Msg.msg(s, "&7There are no placeholder hooks currently registered!");
                return true;
            }
            Msg.msg(s, set.size() + " &7Placeholder hooks registered:");
            Msg.msg(s, set.stream().sorted().collect(Collectors.joining(", ")));
            return true;
        }
        if (args.length > 1 && args[0].equalsIgnoreCase("register")) {
            if (s instanceof Player && !s.hasPermission("placeholderapi.register")) {
                Msg.msg(s, "&cYou don't have permission to do that!");
                return true;
            }
            String string = args[1].replace(".jar", "");
            PlaceholderExpansion ex = this.plugin.getExpansionManager().registerExpansion(string);
            if (ex == null) {
                Msg.msg(s, "&cFailed to register expansion from " + string);
                return true;
            }
            Msg.msg(s, "&aSuccessfully registered expansion: &f" + ex.getName());
            return true;
        }
        if (args.length > 1 && args[0].equalsIgnoreCase("unregister")) {
            if (s instanceof Player && !s.hasPermission("placeholderapi.register")) {
                Msg.msg(s, "&cYou don't have permission to do that!");
                return true;
            }
            PlaceholderExpansion placeholderExpansion = this.plugin.getExpansionManager().getRegisteredExpansion(args[1]);
            if (placeholderExpansion == null) {
                Msg.msg(s, "&cFailed to find expansion: &f" + args[1]);
                return true;
            }
            if (PlaceholderAPI.unregisterExpansion(placeholderExpansion)) {
                Msg.msg(s, "&aSuccessfully unregistered expansion: &f" + placeholderExpansion.getName());
                return true;
            }
            Msg.msg(s, "&cFailed to unregister expansion: &f" + placeholderExpansion.getName());
            return true;
        }
        Msg.msg(s, "&cIncorrect usage! &7/papi help");
        return true;
    }
}

