/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.PlaceholderHook;
import me.clip.placeholderapi.PlaceholderListener;
import me.clip.placeholderapi.ServerLoadEventListener;
import me.clip.placeholderapi.commands.PlaceholderAPICommands;
import me.clip.placeholderapi.configuration.PlaceholderAPIConfig;
import me.clip.placeholderapi.expansion.ExpansionManager;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.clip.placeholderapi.expansion.Version;
import me.clip.placeholderapi.expansion.cloud.ExpansionCloudManager;
import me.clip.placeholderapi.external.EZPlaceholderHook;
import me.clip.placeholderapi.metrics.bukkit.Metrics;
import me.clip.placeholderapi.updatechecker.UpdateChecker;
import me.clip.placeholderapi.util.TimeUtil;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PlaceholderAPIPlugin
extends JavaPlugin {
    private static PlaceholderAPIPlugin instance;
    private static SimpleDateFormat dateFormat;
    private static String booleanTrue;
    private static String booleanFalse;
    private static Version serverVersion;
    private PlaceholderAPIConfig config;
    private ExpansionManager expansionManager;
    private ExpansionCloudManager expansionCloud;
    private long startTime;

    private static Version getVersion() {
        String v = "unknown";
        boolean spigot = false;
        try {
            v = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            Class.forName("org.spigotmc.SpigotConfig");
            Class.forName("net.md_5.bungee.api.chat.BaseComponent");
            spigot = true;
        }
        catch (ClassNotFoundException | ExceptionInInitializerError throwable) {
            // empty catch block
        }
        return new Version(v, spigot);
    }

    public static PlaceholderAPIPlugin getInstance() {
        return instance;
    }

    public static SimpleDateFormat getDateFormat() {
        return dateFormat != null ? dateFormat : new SimpleDateFormat("MM/dd/yy HH:mm:ss");
    }

    public static String booleanTrue() {
        return booleanTrue != null ? booleanTrue : "true";
    }

    public static String booleanFalse() {
        return booleanFalse != null ? booleanFalse : "false";
    }

    public static Version getServerVersion() {
        return serverVersion != null ? serverVersion : PlaceholderAPIPlugin.getVersion();
    }

    @Override
    public void onLoad() {
        this.startTime = System.currentTimeMillis();
        instance = this;
        serverVersion = PlaceholderAPIPlugin.getVersion();
        this.config = new PlaceholderAPIConfig(this);
        this.expansionManager = new ExpansionManager(this);
    }

    @Override
    public void onEnable() {
        this.config.loadDefConfig();
        this.setupOptions();
        this.getCommand("placeholderapi").setExecutor(new PlaceholderAPICommands(this));
        new PlaceholderListener(this);
        try {
            Class.forName("org.bukkit.event.server.ServerLoadEvent");
            new ServerLoadEventListener(this);
        }
        catch (ClassNotFoundException | ExceptionInInitializerError exception) {
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
                this.getLogger().info("Placeholder expansion registration initializing...");
                Map<String, PlaceholderHook> alreadyRegistered = PlaceholderAPI.getPlaceholders();
                this.getExpansionManager().registerAllExpansions();
                if (alreadyRegistered != null && !alreadyRegistered.isEmpty()) {
                    alreadyRegistered.forEach(PlaceholderAPI::registerPlaceholderHook);
                }
            }, 1L);
        }
        if (this.config.checkUpdates()) {
            new UpdateChecker(this).fetch();
        }
        if (this.config.isCloudEnabled()) {
            this.enableCloud();
        }
        this.setupMetrics();
        this.getServer().getScheduler().runTaskLater((Plugin)this, this::checkHook, 40L);
    }

    @Override
    public void onDisable() {
        this.disableCloud();
        PlaceholderAPI.unregisterAll();
        this.expansionManager = null;
        Bukkit.getScheduler().cancelTasks(this);
        serverVersion = null;
        instance = null;
    }

    public void reloadConf(CommandSender s) {
        boolean cloudEnabled = this.expansionCloud != null;
        PlaceholderAPI.unregisterAllProvidedExpansions();
        this.reloadConfig();
        this.setupOptions();
        this.expansionManager.registerAllExpansions();
        if (!this.config.isCloudEnabled()) {
            this.disableCloud();
        } else if (!cloudEnabled) {
            this.enableCloud();
        }
        s.sendMessage(ChatColor.translateAlternateColorCodes('&', PlaceholderAPI.getRegisteredIdentifiers().size() + " &aplaceholder hooks successfully registered!"));
    }

    private void checkHook() {
        Map<String, PlaceholderHook> loaded = PlaceholderAPI.getPlaceholders();
        loaded.values().forEach(h -> {
            if (h instanceof EZPlaceholderHook) {
                String author;
                try {
                    author = Bukkit.getPluginManager().getPlugin(((EZPlaceholderHook)h).getPluginName()).getDescription().getAuthors().toString();
                }
                catch (Exception ex) {
                    author = "the author of the hook's plugin";
                }
                this.getLogger().severe(((EZPlaceholderHook)h).getPluginName() + " is currently using a deprecated method to hook into PlaceholderAPI. Placeholders for that plugin no longer work. " + "Please consult {author} and urge them to update it ASAP.".replace("{author}", author));
                PlaceholderAPI.unregisterPlaceholderHook(((EZPlaceholderHook)h).getPlaceholderName());
            }
        });
    }

    private void setupOptions() {
        booleanTrue = this.config.booleanTrue();
        if (booleanTrue == null) {
            booleanTrue = "true";
        }
        if ((booleanFalse = this.config.booleanFalse()) == null) {
            booleanFalse = "false";
        }
        try {
            dateFormat = new SimpleDateFormat(this.config.dateFormat());
        }
        catch (Exception e) {
            dateFormat = new SimpleDateFormat("MM/dd/yy HH:mm:ss");
        }
    }

    private void setupMetrics() {
        Metrics m = new Metrics(this);
        m.addCustomChart(new Metrics.SimplePie("using_expansion_cloud", () -> this.getExpansionCloud() != null ? "yes" : "no"));
        m.addCustomChart(new Metrics.SimplePie("using_spigot", () -> PlaceholderAPIPlugin.getServerVersion().isSpigot() ? "yes" : "no"));
        m.addCustomChart(new Metrics.AdvancedPie("expansions_used", () -> {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            Map<String, PlaceholderHook> p = PlaceholderAPI.getPlaceholders();
            if (!p.isEmpty()) {
                for (PlaceholderHook hook : p.values()) {
                    if (!(hook instanceof PlaceholderExpansion)) continue;
                    PlaceholderExpansion ex = (PlaceholderExpansion)hook;
                    map.put(ex.getRequiredPlugin() == null ? ex.getIdentifier() : ex.getRequiredPlugin(), 1);
                }
            }
            return map;
        }));
    }

    public void enableCloud() {
        if (this.expansionCloud == null) {
            this.expansionCloud = new ExpansionCloudManager(this);
            this.expansionCloud.fetch(this.config.cloudAllowUnverifiedExpansions());
        } else {
            this.expansionCloud.clean();
            this.expansionCloud.fetch(this.config.cloudAllowUnverifiedExpansions());
        }
    }

    public void disableCloud() {
        if (this.expansionCloud != null) {
            this.expansionCloud.clean();
            this.expansionCloud = null;
        }
    }

    public PlaceholderAPIConfig getPlaceholderAPIConfig() {
        return this.config;
    }

    public ExpansionManager getExpansionManager() {
        return this.expansionManager;
    }

    public ExpansionCloudManager getExpansionCloud() {
        return this.expansionCloud;
    }

    public String getUptime() {
        return TimeUtil.getTime((int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - this.startTime));
    }

    public long getUptimeMillis() {
        return System.currentTimeMillis() - this.startTime;
    }
}

