/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.clip.placeholderapi.PlaceholderHook;
import me.clip.placeholderapi.events.ExpansionRegisterEvent;
import me.clip.placeholderapi.events.ExpansionUnregisterEvent;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.clip.placeholderapi.expansion.Relational;
import me.clip.placeholderapi.util.Msg;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PlaceholderAPI {
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("[%]([^%]+)[%]");
    private static final Pattern BRACKET_PLACEHOLDER_PATTERN = Pattern.compile("[{]([^{}]+)[}]");
    private static final Pattern RELATIONAL_PLACEHOLDER_PATTERN = Pattern.compile("[%](rel_)([^%]+)[%]");
    private static final Map<String, PlaceholderHook> placeholders = new HashMap<String, PlaceholderHook>();

    private PlaceholderAPI() {
    }

    public static boolean isRegistered(String identifier) {
        return PlaceholderAPI.getRegisteredIdentifiers().stream().filter(id -> id.equalsIgnoreCase(identifier)).findFirst().orElse(null) != null;
    }

    public static boolean registerPlaceholderHook(String identifier, PlaceholderHook placeholderHook) {
        Validate.notNull(identifier, "Identifier can not be null");
        Validate.notNull(placeholderHook, "Placeholderhook can not be null");
        if (PlaceholderAPI.isRegistered(identifier)) {
            return false;
        }
        placeholders.put(identifier.toLowerCase(), placeholderHook);
        return true;
    }

    public static boolean unregisterPlaceholderHook(String identifier) {
        Validate.notNull(identifier, "Identifier can not be null");
        return placeholders.remove(identifier.toLowerCase()) != null;
    }

    public static Set<String> getRegisteredIdentifiers() {
        return ImmutableSet.copyOf(placeholders.keySet());
    }

    public static Map<String, PlaceholderHook> getPlaceholders() {
        return ImmutableMap.copyOf(placeholders);
    }

    public static Set<PlaceholderExpansion> getExpansions() {
        Set set = PlaceholderAPI.getPlaceholders().values().stream().filter(PlaceholderExpansion.class::isInstance).map(PlaceholderExpansion.class::cast).collect(Collectors.toCollection(HashSet::new));
        return ImmutableSet.copyOf(set);
    }

    public static boolean containsPlaceholders(String text) {
        return text != null && PLACEHOLDER_PATTERN.matcher(text).find();
    }

    public static boolean containsBracketPlaceholders(String text) {
        return text != null && BRACKET_PLACEHOLDER_PATTERN.matcher(text).find();
    }

    public static List<String> setBracketPlaceholders(OfflinePlayer p, List<String> text) {
        return PlaceholderAPI.setPlaceholders(p, text, BRACKET_PLACEHOLDER_PATTERN);
    }

    public static List<String> setPlaceholders(OfflinePlayer p, List<String> text) {
        return PlaceholderAPI.setPlaceholders(p, text, PLACEHOLDER_PATTERN);
    }

    public static List<String> setPlaceholders(OfflinePlayer p, List<String> text, Pattern pattern) {
        if (text == null) {
            return null;
        }
        return text.stream().map(line -> PlaceholderAPI.setPlaceholders(p, line, pattern)).collect(Collectors.toList());
    }

    public static String setBracketPlaceholders(OfflinePlayer player, String text) {
        return PlaceholderAPI.setPlaceholders(player, text, BRACKET_PLACEHOLDER_PATTERN);
    }

    public static String setPlaceholders(OfflinePlayer player, String text) {
        return PlaceholderAPI.setPlaceholders(player, text, PLACEHOLDER_PATTERN);
    }

    public static String setPlaceholders(OfflinePlayer player, String text, Pattern placeholderPattern) {
        return PlaceholderAPI.setPlaceholders(player, text, placeholderPattern, true);
    }

    public static String setPlaceholders(OfflinePlayer player, String text, Pattern placeholderPattern, boolean colorize) {
        if (text == null) {
            return null;
        }
        if (placeholders.isEmpty()) {
            return colorize ? Msg.color(text) : text;
        }
        Matcher m = placeholderPattern.matcher(text);
        Map<String, PlaceholderHook> hooks = PlaceholderAPI.getPlaceholders();
        while (m.find()) {
            String value;
            String format = m.group(1);
            int index = format.indexOf("_");
            if (index <= 0 || index >= format.length()) continue;
            String identifier = format.substring(0, index).toLowerCase();
            String params = format.substring(index + 1);
            if (!hooks.containsKey(identifier) || (value = hooks.get(identifier).onRequest(player, params)) == null) continue;
            text = text.replaceAll(Pattern.quote(m.group()), Matcher.quoteReplacement(value));
        }
        return colorize ? Msg.color(text) : text;
    }

    public static List<String> setRelationalPlaceholders(Player one, Player two, List<String> text) {
        if (text == null) {
            return null;
        }
        return text.stream().map(line -> PlaceholderAPI.setRelationalPlaceholders(one, two, line)).collect(Collectors.toList());
    }

    public static String setRelationalPlaceholders(Player one, Player two, String text) {
        return PlaceholderAPI.setRelationalPlaceholders(one, two, text, true);
    }

    public static String setRelationalPlaceholders(Player one, Player two, String text, boolean colorize) {
        if (text == null) {
            return null;
        }
        if (placeholders.isEmpty()) {
            return colorize ? Msg.color(text) : text;
        }
        Matcher m = RELATIONAL_PLACEHOLDER_PATTERN.matcher(text);
        Map<String, PlaceholderHook> hooks = PlaceholderAPI.getPlaceholders();
        while (m.find()) {
            Relational rel;
            String value;
            String format = m.group(2);
            int index = format.indexOf("_");
            if (index <= 0 || index >= format.length()) continue;
            String identifier = format.substring(0, index).toLowerCase();
            String params = format.substring(index + 1);
            if (!hooks.containsKey(identifier) || !(hooks.get(identifier) instanceof Relational) || (value = (rel = (Relational)((Object)hooks.get(identifier))).onPlaceholderRequest(one, two, params)) == null) continue;
            text = text.replaceAll(Pattern.quote(m.group()), Matcher.quoteReplacement(value));
        }
        return colorize ? Msg.color(text) : text;
    }

    protected static void unregisterAll() {
        PlaceholderAPI.unregisterAllProvidedExpansions();
        placeholders.clear();
    }

    public static void unregisterAllProvidedExpansions() {
        if (placeholders.isEmpty()) {
            return;
        }
        PlaceholderAPI.getPlaceholders().forEach((key, value) -> {
            PlaceholderExpansion ex;
            if (value instanceof PlaceholderExpansion && !(ex = (PlaceholderExpansion)value).persist()) {
                PlaceholderAPI.unregisterExpansion(ex);
            }
        });
    }

    public static boolean registerExpansion(PlaceholderExpansion ex) {
        ExpansionRegisterEvent ev = new ExpansionRegisterEvent(ex);
        Bukkit.getPluginManager().callEvent(ev);
        if (ev.isCancelled()) {
            return false;
        }
        return PlaceholderAPI.registerPlaceholderHook(ex.getIdentifier(), (PlaceholderHook)ex);
    }

    public static boolean unregisterExpansion(PlaceholderExpansion ex) {
        if (PlaceholderAPI.unregisterPlaceholderHook(ex.getIdentifier())) {
            Bukkit.getPluginManager().callEvent(new ExpansionUnregisterEvent(ex));
            return true;
        }
        return false;
    }

    public static Pattern getPlaceholderPattern() {
        return PLACEHOLDER_PATTERN;
    }

    public static Pattern getBracketPlaceholderPattern() {
        return BRACKET_PLACEHOLDER_PATTERN;
    }

    public static Pattern getRelationalPlaceholderPattern() {
        return RELATIONAL_PLACEHOLDER_PATTERN;
    }

    @Deprecated
    public static Set<String> getRegisteredPlaceholderPlugins() {
        return PlaceholderAPI.getRegisteredIdentifiers();
    }

    @Deprecated
    public static Set<String> getExternalPlaceholderPlugins() {
        return null;
    }

    @Deprecated
    public static boolean registerPlaceholderHook(Plugin plugin, PlaceholderHook placeholderHook) {
        return plugin != null && PlaceholderAPI.registerPlaceholderHook(plugin.getName(), placeholderHook);
    }

    @Deprecated
    public static boolean unregisterPlaceholderHook(Plugin plugin) {
        return plugin != null && PlaceholderAPI.unregisterPlaceholderHook(plugin.getName());
    }

    public static String setPlaceholders(Player p, String text) {
        return PlaceholderAPI.setPlaceholders((OfflinePlayer)p, text, PLACEHOLDER_PATTERN);
    }

    public static List<String> setPlaceholders(Player p, List<String> text) {
        return PlaceholderAPI.setPlaceholders((OfflinePlayer)p, text, PLACEHOLDER_PATTERN);
    }

    public static String setBracketPlaceholders(Player p, String text) {
        return PlaceholderAPI.setPlaceholders((OfflinePlayer)p, text, BRACKET_PLACEHOLDER_PATTERN);
    }

    public static List<String> setBracketPlaceholders(Player p, List<String> text) {
        return PlaceholderAPI.setPlaceholders((OfflinePlayer)p, text, BRACKET_PLACEHOLDER_PATTERN);
    }
}

