/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.protection;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldguard.domains.Association;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class DelayedRegionOverlapAssociation
implements RegionAssociable {
    private final RegionQuery query;
    private final Location location;
    @Nullable
    private Set<ProtectedRegion> source;

    public DelayedRegionOverlapAssociation(RegionQuery query, Location location) {
        Preconditions.checkNotNull(query);
        Preconditions.checkNotNull(location);
        this.query = query;
        this.location = location;
    }

    @Override
    public Association getAssociation(List<ProtectedRegion> regions) {
        if (this.source == null) {
            ApplicableRegionSet result = this.query.getApplicableRegions(this.location);
            this.source = result.getRegions();
        }
        for (ProtectedRegion region : regions) {
            if ((!region.getId().equals("__global__") || !this.source.isEmpty()) && !this.source.contains(region)) continue;
            return Association.OWNER;
        }
        return Association.NON_MEMBER;
    }
}

