/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.listener;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.gamemode.GameMode;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.bukkit.event.player.ProcessPlayerEvent;
import com.sk89q.worldguard.bukkit.listener.RegionProtectionListener;
import com.sk89q.worldguard.bukkit.util.Events;
import com.sk89q.worldguard.bukkit.util.Materials;
import com.sk89q.worldguard.config.ConfigurationManager;
import com.sk89q.worldguard.config.WorldConfiguration;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import com.sk89q.worldguard.session.MoveType;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.handler.GameModeFlag;
import com.sk89q.worldguard.util.Entities;
import com.sk89q.worldguard.util.command.CommandFilter;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.PluginManager;

public class WorldGuardPlayerListener
implements Listener {
    private static final Logger log = Logger.getLogger(WorldGuardPlayerListener.class.getCanonicalName());
    private static final Pattern opPattern = Pattern.compile("^/(?:minecraft:)?(?:bukkit:)?(?:de)?op(?:\\s.*)?$", 2);
    private WorldGuardPlugin plugin;

    public WorldGuardPlayerListener(WorldGuardPlugin plugin) {
        this.plugin = plugin;
    }

    public void registerEvents() {
        PluginManager pm = this.plugin.getServer().getPluginManager();
        pm.registerEvents(this, this.plugin);
    }

    @EventHandler
    public void onPlayerGameModeChange(PlayerGameModeChangeEvent event) {
        GameModeFlag handler;
        Player player = event.getPlayer();
        LocalPlayer localPlayer = this.plugin.wrapPlayer(player);
        WorldConfiguration wcfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager().get(localPlayer.getWorld());
        Session session = WorldGuard.getInstance().getPlatform().getSessionManager().getIfPresent(localPlayer);
        if (session != null && (handler = session.getHandler(GameModeFlag.class)) != null && wcfg.useRegions && !WorldGuard.getInstance().getPlatform().getSessionManager().hasBypass(localPlayer, localPlayer.getWorld())) {
            GameMode expected = handler.getSetGameMode();
            if (handler.getOriginalGameMode() != null && expected != null && expected != BukkitAdapter.adapt(event.getNewGameMode())) {
                log.info("Game mode change on " + player.getName() + " has been blocked due to the region GAMEMODE flag");
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        LocalPlayer localPlayer = this.plugin.wrapPlayer(player);
        World world = player.getWorld();
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(localPlayer.getWorld());
        if (cfg.activityHaltToggle) {
            player.sendMessage((Object)((Object)ChatColor.YELLOW) + "Intensive server activity has been HALTED.");
            int removed = 0;
            for (Entity entity : world.getEntities()) {
                if (!Entities.isIntensiveEntity(BukkitAdapter.adapt(entity))) continue;
                entity.remove();
                ++removed;
            }
            if (removed > 10) {
                log.info("Halt-Act: " + removed + " entities (>10) auto-removed from " + player.getWorld());
            }
        }
        if (wcfg.fireSpreadDisableToggle) {
            player.sendMessage((Object)((Object)ChatColor.YELLOW) + "Fire spread is currently globally disabled for this world.");
        }
        Events.fire(new ProcessPlayerEvent(player));
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        LocalPlayer localPlayer = this.plugin.wrapPlayer(player);
        WorldConfiguration wcfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager().get(localPlayer.getWorld());
        if (wcfg.useRegions) {
            RegionQuery query = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery();
            ApplicableRegionSet chatFrom = query.getApplicableRegions(localPlayer.getLocation());
            if (!chatFrom.testState(localPlayer, Flags.SEND_CHAT)) {
                String message = chatFrom.queryValue(localPlayer, Flags.DENY_MESSAGE);
                RegionProtectionListener.formatAndSendDenyMessage("chat", localPlayer, message);
                event.setCancelled(true);
                return;
            }
            boolean anyRemoved = false;
            Iterator<Player> i = event.getRecipients().iterator();
            while (i.hasNext()) {
                Player rPlayer = i.next();
                LocalPlayer rLocal = this.plugin.wrapPlayer(rPlayer);
                if (query.testState(rLocal.getLocation(), rLocal, Flags.RECEIVE_CHAT)) continue;
                i.remove();
                anyRemoved = true;
            }
            if (anyRemoved && event.getRecipients().isEmpty() && wcfg.regionCancelEmptyChatEvents) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerLogin(PlayerLoginEvent event) {
        Player player = event.getPlayer();
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        String hostKey = cfg.hostKeys.get(player.getUniqueId().toString());
        if (hostKey == null) {
            hostKey = cfg.hostKeys.get(player.getName().toLowerCase());
        }
        if (hostKey != null) {
            String hostname = event.getHostname();
            int colonIndex = hostname.indexOf(58);
            if (colonIndex != -1) {
                hostname = hostname.substring(0, colonIndex);
            }
            if (!(hostname.equals(hostKey) || cfg.hostKeysAllowFMLClients && hostname.equals(hostKey + "\u0000FML\u0000"))) {
                event.disallow(PlayerLoginEvent.Result.KICK_OTHER, "You did not join with the valid host key!");
                log.warning("WorldGuard host key check: " + player.getName() + " joined with '" + hostname + "' but '" + hostKey + "' was expected. Kicked!");
                return;
            }
        }
        if (cfg.deopOnJoin) {
            player.setOp(false);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        World world = player.getWorld();
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            this.handleBlockRightClick(event);
        } else if (event.getAction() == Action.PHYSICAL) {
            this.handlePhysicalInteract(event);
        }
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(BukkitAdapter.adapt(world));
        if (wcfg.removeInfiniteStacks && !this.plugin.hasPermission(player, "worldguard.override.infinite-stack")) {
            int slot = player.getInventory().getHeldItemSlot();
            ItemStack heldItem = player.getInventory().getItem(slot);
            if (heldItem != null && heldItem.getAmount() < 0) {
                player.getInventory().setItem(slot, null);
                player.sendMessage((Object)((Object)ChatColor.RED) + "Infinite stack removed.");
            }
        }
    }

    private void handleBlockRightClick(PlayerInteractEvent event) {
        if (event.useItemInHand() == Event.Result.DENY) {
            return;
        }
        Block block = event.getClickedBlock();
        World world = block.getWorld();
        Material type = block.getType();
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(BukkitAdapter.adapt(world));
        if (Materials.isInventoryBlock(type) && wcfg.removeInfiniteStacks && !this.plugin.hasPermission(player, "worldguard.override.infinite-stack")) {
            for (int slot = 0; slot < 40; ++slot) {
                ItemStack heldItem = player.getInventory().getItem(slot);
                if (heldItem == null || heldItem.getAmount() >= 0) continue;
                player.getInventory().setItem(slot, null);
                player.sendMessage((Object)((Object)ChatColor.RED) + "Infinite stack in slot #" + slot + " removed.");
            }
        }
        if (wcfg.useRegions) {
            ApplicableRegionSet set = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().getApplicableRegions(BukkitAdapter.adapt(block.getLocation()));
            LocalPlayer localPlayer = this.plugin.wrapPlayer(player);
            if (item != null && item.getType().getKey().toString().equals(wcfg.regionWand) && this.plugin.hasPermission(player, "worldguard.region.wand")) {
                if (set.size() > 0) {
                    player.sendMessage((Object)((Object)ChatColor.YELLOW) + "Can you build? " + (set.testState(localPlayer, Flags.BUILD) ? "Yes" : "No"));
                    StringBuilder str = new StringBuilder();
                    Iterator it = set.iterator();
                    while (it.hasNext()) {
                        str.append(((ProtectedRegion)it.next()).getId());
                        if (!it.hasNext()) continue;
                        str.append(", ");
                    }
                    localPlayer.print("Applicable regions: " + str);
                } else {
                    localPlayer.print("WorldGuard: No defined regions here!");
                }
                event.setUseItemInHand(Event.Result.DENY);
            }
        }
    }

    private void handlePhysicalInteract(PlayerInteractEvent event) {
        if (event.useInteractedBlock() == Event.Result.DENY) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getClickedBlock();
        World world = player.getWorld();
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(BukkitAdapter.adapt(world));
        if (block.getType() == Material.FARMLAND && wcfg.disablePlayerCropTrampling) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        ApplicableRegionSet set;
        Location spawn;
        Player player = event.getPlayer();
        LocalPlayer localPlayer = this.plugin.wrapPlayer(player);
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(localPlayer.getWorld());
        if (wcfg.useRegions && (spawn = (set = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().getApplicableRegions(localPlayer.getLocation())).queryValue(localPlayer, Flags.SPAWN_LOC)) != null) {
            event.setRespawnLocation(BukkitAdapter.adapt(spawn));
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onItemHeldChange(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(BukkitAdapter.adapt(player.getWorld()));
        if (wcfg.removeInfiniteStacks && !this.plugin.hasPermission(player, "worldguard.override.infinite-stack")) {
            int newSlot = event.getNewSlot();
            ItemStack heldItem = player.getInventory().getItem(newSlot);
            if (heldItem != null && heldItem.getAmount() < 0) {
                player.getInventory().setItem(newSlot, null);
                player.sendMessage((Object)((Object)ChatColor.RED) + "Infinite stack removed.");
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        LocalPlayer localPlayer = this.plugin.wrapPlayer(player);
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(localPlayer.getWorld());
        if (wcfg.useRegions && cfg.usePlayerTeleports) {
            ApplicableRegionSet set = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().getApplicableRegions(BukkitAdapter.adapt(event.getTo()));
            ApplicableRegionSet setFrom = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().getApplicableRegions(BukkitAdapter.adapt(event.getFrom()));
            if (event.getCause() == PlayerTeleportEvent.TeleportCause.ENDER_PEARL) {
                if (!WorldGuard.getInstance().getPlatform().getSessionManager().hasBypass(localPlayer, localPlayer.getWorld())) {
                    boolean cancel = false;
                    String message = null;
                    if (!setFrom.testState(localPlayer, Flags.ENDERPEARL)) {
                        cancel = true;
                        message = setFrom.queryValue(localPlayer, Flags.EXIT_DENY_MESSAGE);
                    } else if (!set.testState(localPlayer, Flags.ENDERPEARL)) {
                        cancel = true;
                        message = set.queryValue(localPlayer, Flags.ENTRY_DENY_MESSAGE);
                    }
                    if (cancel) {
                        if (message != null) {
                            player.sendMessage(message);
                        }
                        event.setCancelled(true);
                        return;
                    }
                }
            } else if (event.getCause() == PlayerTeleportEvent.TeleportCause.CHORUS_FRUIT && !WorldGuard.getInstance().getPlatform().getSessionManager().hasBypass(localPlayer, localPlayer.getWorld())) {
                boolean cancel = false;
                String message = null;
                if (!setFrom.testState(localPlayer, Flags.CHORUS_TELEPORT)) {
                    cancel = true;
                    message = setFrom.queryValue(localPlayer, Flags.EXIT_DENY_MESSAGE);
                } else if (!set.testState(localPlayer, Flags.CHORUS_TELEPORT)) {
                    cancel = true;
                    message = set.queryValue(localPlayer, Flags.ENTRY_DENY_MESSAGE);
                }
                if (cancel) {
                    if (message != null) {
                        player.sendMessage(message);
                    }
                    event.setCancelled(true);
                    return;
                }
            }
            if (null != WorldGuard.getInstance().getPlatform().getSessionManager().get(localPlayer).testMoveTo(localPlayer, BukkitAdapter.adapt(event.getTo()), MoveType.TELEPORT)) {
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        Set blockedCommands;
        ApplicableRegionSet set;
        Set allowedCommands;
        CommandFilter test;
        Player player = event.getPlayer();
        LocalPlayer localPlayer = this.plugin.wrapPlayer(player);
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(localPlayer.getWorld());
        if (wcfg.useRegions && !WorldGuard.getInstance().getPlatform().getSessionManager().hasBypass(localPlayer, localPlayer.getWorld()) && !(test = new CommandFilter(allowedCommands = (Set)((Object)(set = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().getApplicableRegions(localPlayer.getLocation())).queryValue(localPlayer, Flags.ALLOWED_CMDS)), blockedCommands = (Set)((Object)set.queryValue(localPlayer, Flags.BLOCKED_CMDS)))).apply(event.getMessage())) {
            String message = set.queryValue(localPlayer, Flags.DENY_MESSAGE);
            RegionProtectionListener.formatAndSendDenyMessage("use " + event.getMessage(), localPlayer, message);
            event.setCancelled(true);
            return;
        }
        if (cfg.blockInGameOp && opPattern.matcher(event.getMessage()).matches()) {
            player.sendMessage((Object)((Object)ChatColor.RED) + "/op and /deop can only be used in console (as set by a WG setting).");
            event.setCancelled(true);
            return;
        }
    }
}

