/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.listener;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.BukkitWorldConfiguration;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.bukkit.util.Materials;
import com.sk89q.worldguard.config.ConfigurationManager;
import com.sk89q.worldguard.config.WorldConfiguration;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.util.SpongeUtil;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowman;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.EntityBlockFormEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class WorldGuardBlockListener
implements Listener {
    private WorldGuardPlugin plugin;

    public WorldGuardBlockListener(WorldGuardPlugin plugin) {
        this.plugin = plugin;
    }

    public void registerEvents() {
        this.plugin.getServer().getPluginManager().registerEvents(this, this.plugin);
    }

    private WorldConfiguration getWorldConfig(World world) {
        return WorldGuard.getInstance().getPlatform().getGlobalStateManager().get(BukkitAdapter.adapt(world));
    }

    private WorldConfiguration getWorldConfig(Player player) {
        return this.getWorldConfig(player.getWorld());
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        ItemStack held;
        ItemMeta meta;
        Player player = event.getPlayer();
        WorldConfiguration wcfg = this.getWorldConfig(player);
        if (!wcfg.itemDurability && (meta = (held = player.getInventory().getItemInMainHand()).getItemMeta()) != null) {
            ((Damageable)((Object)meta)).setDamage(0);
            held.setItemMeta(meta);
            player.getInventory().setItemInMainHand(held);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockFromTo(BlockFromToEvent event) {
        Material targetId;
        World world = event.getBlock().getWorld();
        Block blockFrom = event.getBlock();
        Block blockTo = event.getToBlock();
        boolean isWater = blockFrom.getType() == Material.WATER;
        boolean isLava = blockFrom.getType() == Material.LAVA;
        boolean isAir = blockFrom.getType() == Material.AIR;
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        WorldConfiguration wcfg = this.getWorldConfig(event.getBlock().getWorld());
        if (cfg.activityHaltToggle) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.simulateSponge && isWater) {
            int ox = blockTo.getX();
            int oy = blockTo.getY();
            int oz = blockTo.getZ();
            for (int cx = -wcfg.spongeRadius; cx <= wcfg.spongeRadius; ++cx) {
                for (int cy = -wcfg.spongeRadius; cy <= wcfg.spongeRadius; ++cy) {
                    for (int cz = -wcfg.spongeRadius; cz <= wcfg.spongeRadius; ++cz) {
                        Block sponge = world.getBlockAt(ox + cx, oy + cy, oz + cz);
                        if (sponge.getType() != Material.SPONGE || wcfg.redstoneSponges && sponge.isBlockIndirectlyPowered()) continue;
                        event.setCancelled(true);
                        return;
                    }
                }
            }
        }
        if (!wcfg.preventWaterDamage.isEmpty()) {
            Material targetId2 = blockTo.getType();
            if ((isAir || isWater) && wcfg.preventWaterDamage.contains(BukkitAdapter.asBlockType(targetId2).getId())) {
                event.setCancelled(true);
                return;
            }
        }
        if (!wcfg.allowedLavaSpreadOver.isEmpty() && isLava && !wcfg.allowedLavaSpreadOver.contains(BukkitAdapter.asBlockType(targetId = blockTo.getRelative(0, -1, 0).getType()).getId())) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.highFreqFlags && isWater && WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().queryState(BukkitAdapter.adapt(blockFrom.getLocation()), (RegionAssociable)null, Flags.WATER_FLOW) == StateFlag.State.DENY) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.highFreqFlags && isLava && !StateFlag.test(WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().queryState(BukkitAdapter.adapt(blockFrom.getLocation()), (RegionAssociable)null, Flags.LAVA_FLOW))) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.disableObsidianGenerators && (isAir || isLava) && (blockTo.getType() == Material.REDSTONE_WIRE || blockTo.getType() == Material.TRIPWIRE)) {
            blockTo.setType(Material.AIR);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockIgnite(BlockIgniteEvent event) {
        int z;
        int y;
        int x;
        boolean isFireSpread;
        BlockIgniteEvent.IgniteCause cause = event.getCause();
        Block block = event.getBlock();
        World world = block.getWorld();
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        WorldConfiguration wcfg = this.getWorldConfig(world);
        if (cfg.activityHaltToggle) {
            event.setCancelled(true);
            return;
        }
        boolean bl = isFireSpread = cause == BlockIgniteEvent.IgniteCause.SPREAD;
        if (wcfg.preventLightningFire && cause == BlockIgniteEvent.IgniteCause.LIGHTNING) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.preventLavaFire && cause == BlockIgniteEvent.IgniteCause.LAVA) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.disableFireSpread && isFireSpread) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.blockLighter && (cause == BlockIgniteEvent.IgniteCause.FLINT_AND_STEEL || cause == BlockIgniteEvent.IgniteCause.FIREBALL) && event.getPlayer() != null && !this.plugin.hasPermission(event.getPlayer(), "worldguard.override.lighter")) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.fireSpreadDisableToggle && isFireSpread) {
            event.setCancelled(true);
            return;
        }
        if (!wcfg.disableFireSpreadBlocks.isEmpty() && isFireSpread && (wcfg.disableFireSpreadBlocks.contains(BukkitAdapter.asBlockType(world.getBlockAt(x = block.getX(), (y = block.getY()) - 1, z = block.getZ()).getType()).getId()) || wcfg.disableFireSpreadBlocks.contains(BukkitAdapter.asBlockType(world.getBlockAt(x + 1, y, z).getType()).getId()) || wcfg.disableFireSpreadBlocks.contains(BukkitAdapter.asBlockType(world.getBlockAt(x - 1, y, z).getType()).getId()) || wcfg.disableFireSpreadBlocks.contains(BukkitAdapter.asBlockType(world.getBlockAt(x, y, z - 1).getType()).getId()) || wcfg.disableFireSpreadBlocks.contains(BukkitAdapter.asBlockType(world.getBlockAt(x, y, z + 1).getType()).getId()))) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.useRegions) {
            ApplicableRegionSet set = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().getApplicableRegions(BukkitAdapter.adapt(block.getLocation()));
            if (wcfg.highFreqFlags && isFireSpread && !set.testState(null, Flags.FIRE_SPREAD)) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.highFreqFlags && cause == BlockIgniteEvent.IgniteCause.LAVA && !set.testState(null, Flags.LAVA_FIRE)) {
                event.setCancelled(true);
                return;
            }
            if (cause == BlockIgniteEvent.IgniteCause.FIREBALL && event.getPlayer() == null && !set.testState(null, Flags.GHAST_FIREBALL)) {
                event.setCancelled(true);
                return;
            }
            if (cause == BlockIgniteEvent.IgniteCause.LIGHTNING && !set.testState(null, Flags.LIGHTNING)) {
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockBurn(BlockBurnEvent event) {
        Block block;
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        BukkitWorldConfiguration wcfg = (BukkitWorldConfiguration)this.getWorldConfig(event.getBlock().getWorld());
        if (cfg.activityHaltToggle) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.disableFireSpread) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.fireSpreadDisableToggle) {
            Block block2 = event.getBlock();
            event.setCancelled(true);
            this.checkAndDestroyAround(block2.getWorld(), block2.getX(), block2.getY(), block2.getZ(), Material.FIRE);
            return;
        }
        if (!wcfg.disableFireSpreadBlocks.isEmpty() && wcfg.disableFireSpreadBlocks.contains(BukkitAdapter.asBlockType((block = event.getBlock()).getType()).getId())) {
            event.setCancelled(true);
            this.checkAndDestroyAround(block.getWorld(), block.getX(), block.getY(), block.getZ(), Material.FIRE);
            return;
        }
        if (wcfg.isChestProtected(BukkitAdapter.adapt(event.getBlock().getLocation()))) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.useRegions) {
            block = event.getBlock();
            int x = block.getX();
            int y = block.getY();
            int z = block.getZ();
            ApplicableRegionSet set = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().getApplicableRegions(BukkitAdapter.adapt(block.getLocation()));
            if (!set.testState(null, Flags.FIRE_SPREAD)) {
                this.checkAndDestroyAround(block.getWorld(), x, y, z, Material.FIRE);
                event.setCancelled(true);
            }
        }
    }

    private void checkAndDestroyAround(World world, int x, int y, int z, Material required) {
        this.checkAndDestroy(world, x, y, z + 1, required);
        this.checkAndDestroy(world, x, y, z - 1, required);
        this.checkAndDestroy(world, x, y + 1, z, required);
        this.checkAndDestroy(world, x, y - 1, z, required);
        this.checkAndDestroy(world, x + 1, y, z, required);
        this.checkAndDestroy(world, x - 1, y, z, required);
    }

    private void checkAndDestroy(World world, int x, int y, int z, Material required) {
        if (world.getBlockAt(x, y, z).getType() == required) {
            world.getBlockAt(x, y, z).setType(Material.AIR);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockPhysics(BlockPhysicsEvent event) {
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        WorldConfiguration wcfg = this.getWorldConfig(event.getBlock().getWorld());
        if (cfg.activityHaltToggle) {
            event.setCancelled(true);
            return;
        }
        Material id = event.getBlock().getType();
        if (id == Material.GRAVEL && wcfg.noPhysicsGravel) {
            event.setCancelled(true);
            return;
        }
        if (id == Material.SAND && wcfg.noPhysicsSand) {
            event.setCancelled(true);
            return;
        }
        if (id == Material.NETHER_PORTAL && wcfg.allowPortalAnywhere) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.ropeLadders && event.getBlock().getType() == Material.LADDER && event.getBlock().getRelative(0, 1, 0).getType() == Material.LADDER) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        Block target = event.getBlock();
        World world = target.getWorld();
        WorldConfiguration wcfg = this.getWorldConfig(world);
        if (wcfg.simulateSponge && target.getType() == Material.SPONGE) {
            if (wcfg.redstoneSponges && target.isBlockIndirectlyPowered()) {
                return;
            }
            int ox = target.getX();
            int oy = target.getY();
            int oz = target.getZ();
            SpongeUtil.clearSpongeWater(BukkitAdapter.adapt(world), ox, oy, oz);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockRedstoneChange(BlockRedstoneEvent event) {
        Block blockTo = event.getBlock();
        World world = blockTo.getWorld();
        WorldConfiguration wcfg = this.getWorldConfig(world);
        if (wcfg.simulateSponge && wcfg.redstoneSponges) {
            int ox = blockTo.getX();
            int oy = blockTo.getY();
            int oz = blockTo.getZ();
            for (int cx = -1; cx <= 1; ++cx) {
                for (int cy = -1; cy <= 1; ++cy) {
                    for (int cz = -1; cz <= 1; ++cz) {
                        Block sponge = world.getBlockAt(ox + cx, oy + cy, oz + cz);
                        if (sponge.getType() == Material.SPONGE && sponge.isBlockIndirectlyPowered()) {
                            SpongeUtil.clearSpongeWater(BukkitAdapter.adapt(world), ox + cx, oy + cy, oz + cz);
                            continue;
                        }
                        if (sponge.getType() != Material.SPONGE || sponge.isBlockIndirectlyPowered()) continue;
                        SpongeUtil.addSpongeWater(BukkitAdapter.adapt(world), ox + cx, oy + cy, oz + cz);
                    }
                }
            }
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onLeavesDecay(LeavesDecayEvent event) {
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        WorldConfiguration wcfg = this.getWorldConfig(event.getBlock().getWorld());
        if (cfg.activityHaltToggle) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.disableLeafDecay) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.useRegions && !StateFlag.test(WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().queryState(BukkitAdapter.adapt(event.getBlock().getLocation()), (RegionAssociable)null, Flags.LEAF_DECAY))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockForm(BlockFormEvent event) {
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        WorldConfiguration wcfg = this.getWorldConfig(event.getBlock().getWorld());
        if (cfg.activityHaltToggle) {
            event.setCancelled(true);
            return;
        }
        Material type = event.getNewState().getType();
        if (event instanceof EntityBlockFormEvent) {
            if (((EntityBlockFormEvent)event).getEntity() instanceof Snowman && wcfg.disableSnowmanTrails) {
                event.setCancelled(true);
                return;
            }
            return;
        }
        if (type == Material.ICE) {
            if (wcfg.disableIceFormation) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.useRegions && !StateFlag.test(WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().queryState(BukkitAdapter.adapt(event.getBlock().getLocation()), (RegionAssociable)null, Flags.ICE_FORM))) {
                event.setCancelled(true);
                return;
            }
        }
        if (type == Material.SNOW) {
            Material targetId;
            if (wcfg.disableSnowFormation) {
                event.setCancelled(true);
                return;
            }
            if (!wcfg.allowedSnowFallOver.isEmpty() && !wcfg.allowedSnowFallOver.contains(BukkitAdapter.asBlockType(targetId = event.getBlock().getRelative(0, -1, 0).getType()).getId())) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.useRegions && !StateFlag.test(WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().queryState(BukkitAdapter.adapt(event.getBlock().getLocation()), (RegionAssociable)null, Flags.SNOW_FALL))) {
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockSpread(BlockSpreadEvent event) {
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        WorldConfiguration wcfg = this.getWorldConfig(event.getBlock().getWorld());
        if (cfg.activityHaltToggle) {
            event.setCancelled(true);
            return;
        }
        Material newType = event.getNewState().getType();
        if (Materials.isMushroom(newType)) {
            if (wcfg.disableMushroomSpread) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.useRegions && !StateFlag.test(WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().queryState(BukkitAdapter.adapt(event.getBlock().getLocation()), (RegionAssociable)null, Flags.MUSHROOMS))) {
                event.setCancelled(true);
                return;
            }
        }
        if (newType == Material.GRASS_BLOCK) {
            if (wcfg.disableGrassGrowth) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.useRegions && !StateFlag.test(WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().queryState(BukkitAdapter.adapt(event.getBlock().getLocation()), (RegionAssociable)null, Flags.GRASS_SPREAD))) {
                event.setCancelled(true);
                return;
            }
        }
        if (newType == Material.MYCELIUM) {
            if (wcfg.disableMyceliumSpread) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.useRegions && !StateFlag.test(WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().queryState(BukkitAdapter.adapt(event.getBlock().getLocation()), (RegionAssociable)null, Flags.MYCELIUM_SPREAD))) {
                event.setCancelled(true);
                return;
            }
        }
        if (newType == Material.VINE || newType == Material.KELP) {
            if (wcfg.disableVineGrowth) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.useRegions && !StateFlag.test(WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().queryState(BukkitAdapter.adapt(event.getBlock().getLocation()), (RegionAssociable)null, Flags.VINE_GROWTH))) {
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockGrow(BlockGrowEvent event) {
        WorldConfiguration wcfg = this.getWorldConfig(event.getBlock().getWorld());
        Material type = event.getNewState().getType();
        if (Materials.isCrop(type)) {
            if (wcfg.disableCropGrowth) {
                event.setCancelled(false);
                return;
            }
            if (wcfg.useRegions && !StateFlag.test(WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().queryState(BukkitAdapter.adapt(event.getBlock().getLocation()), (RegionAssociable)null, Flags.CROP_GROWTH))) {
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockFade(BlockFadeEvent event) {
        WorldConfiguration wcfg = this.getWorldConfig(event.getBlock().getWorld());
        if (event.getBlock().getType() == Material.ICE) {
            if (wcfg.disableIceMelting) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.useRegions && !StateFlag.test(WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().queryState(BukkitAdapter.adapt(event.getBlock().getLocation()), (RegionAssociable)null, Flags.ICE_MELT))) {
                event.setCancelled(true);
                return;
            }
        } else if (event.getBlock().getType() == Material.FROSTED_ICE) {
            if (wcfg.useRegions && !StateFlag.test(WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().queryState(BukkitAdapter.adapt(event.getBlock().getLocation()), (RegionAssociable)null, Flags.FROSTED_ICE_MELT))) {
                event.setCancelled(true);
                return;
            }
        } else if (event.getBlock().getType() == Material.SNOW) {
            if (wcfg.disableSnowMelting) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.useRegions && !StateFlag.test(WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().queryState(BukkitAdapter.adapt(event.getBlock().getLocation()), (RegionAssociable)null, Flags.SNOW_MELT))) {
                event.setCancelled(true);
                return;
            }
        } else if (event.getBlock().getType() == Material.FARMLAND) {
            if (wcfg.disableSoilDehydration) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.useRegions && !StateFlag.test(WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().queryState(BukkitAdapter.adapt(event.getBlock().getLocation()), (RegionAssociable)null, Flags.SOIL_DRY))) {
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockExplode(BlockExplodeEvent event) {
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        if (cfg.activityHaltToggle) {
            event.setCancelled(true);
            return;
        }
        WorldConfiguration wcfg = this.getWorldConfig(event.getBlock().getWorld());
        if (wcfg.blockOtherExplosions) {
            event.setCancelled(true);
        }
    }
}

