/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.blacklist.target.BlockTarget;
import com.sk89q.worldguard.blacklist.target.ItemTarget;
import com.sk89q.worldguard.blacklist.target.Target;
import com.sk89q.worldguard.blacklist.target.TargetMatcher;
import java.util.Collection;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.inventory.ItemStack;

public class TargetMatcherSet {
    private final Multimap<String, TargetMatcher> entries = HashMultimap.create();

    public boolean add(TargetMatcher matcher) {
        Preconditions.checkNotNull(matcher);
        return this.entries.put(matcher.getMatchedTypeId(), matcher);
    }

    public boolean test(Target target) {
        Collection<TargetMatcher> matchers = this.entries.get(target.getTypeId());
        for (TargetMatcher matcher : matchers) {
            if (!matcher.test(target)) continue;
            return true;
        }
        return false;
    }

    public boolean test(Material material) {
        if (material.isBlock()) {
            return this.test(new BlockTarget(BukkitAdapter.asBlockType(material)));
        }
        return this.test(new ItemTarget(BukkitAdapter.asItemType(material)));
    }

    public boolean test(Block block) {
        return this.test(new BlockTarget(BukkitAdapter.asBlockType(block.getType())));
    }

    public boolean test(BlockState state) {
        return this.test(new BlockTarget(BukkitAdapter.asBlockType(state.getType())));
    }

    public boolean test(ItemStack itemStack) {
        return this.test(new ItemTarget(BukkitAdapter.asItemType(itemStack.getType())));
    }

    public String toString() {
        return this.entries.toString();
    }
}

