/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.blacklist;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.sk89q.worldguard.blacklist.BlacklistEntry;
import com.sk89q.worldguard.blacklist.target.Target;
import com.sk89q.worldguard.blacklist.target.TargetMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class MatcherIndex {
    private static final MatcherIndex EMPTY_INSTANCE = new MatcherIndex(HashBasedTable.create());
    private final Table<String, TargetMatcher, BlacklistEntry> entries;

    private MatcherIndex(Table<String, TargetMatcher, BlacklistEntry> entries) {
        Preconditions.checkNotNull(entries);
        this.entries = entries;
    }

    public List<BlacklistEntry> getEntries(Target target) {
        ArrayList<BlacklistEntry> found = new ArrayList<BlacklistEntry>();
        for (Map.Entry<TargetMatcher, BlacklistEntry> entry : this.entries.row(target.getTypeId()).entrySet()) {
            if (!entry.getKey().test(target)) continue;
            found.add(entry.getValue());
        }
        return found;
    }

    public int size() {
        return this.entries.size();
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public static MatcherIndex getEmptyInstance() {
        return EMPTY_INSTANCE;
    }

    public static class Builder {
        private final Table<String, TargetMatcher, BlacklistEntry> entries = HashBasedTable.create();

        public Builder add(TargetMatcher matcher, BlacklistEntry entry) {
            Preconditions.checkNotNull(matcher);
            Preconditions.checkNotNull(this.entries);
            this.entries.put(matcher.getMatchedTypeId(), matcher, entry);
            return this;
        }

        public MatcherIndex build() {
            return new MatcherIndex(this.entries);
        }
    }
}

