/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world.registry;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.util.gson.VectorAdapter;
import com.sk89q.worldedit.util.io.ResourceLoader;
import com.sk89q.worldedit.world.DataFixer;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.item.ItemType;
import com.sk89q.worldedit.world.item.ItemTypes;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LegacyMapper {
    private static final Logger log = LoggerFactory.getLogger(LegacyMapper.class);
    private static LegacyMapper INSTANCE;
    private Map<String, String> blockEntries = new HashMap<String, String>();
    private Map<String, BlockState> stringToBlockMap = new HashMap<String, BlockState>();
    private Multimap<BlockState, String> blockToStringMap = HashMultimap.create();
    private Map<String, ItemType> stringToItemMap = new HashMap<String, ItemType>();
    private Multimap<ItemType, String> itemToStringMap = HashMultimap.create();

    private LegacyMapper() {
        try {
            this.loadFromResource();
        }
        catch (Throwable e) {
            log.warn("Failed to load the built-in legacy id registry", e);
        }
    }

    private void loadFromResource() throws IOException {
        String value;
        String id;
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter((Type)((Object)Vector3.class), new VectorAdapter());
        Gson gson = gsonBuilder.disableHtmlEscaping().create();
        URL url = ResourceLoader.getResource(LegacyMapper.class, "legacy.json");
        if (url == null) {
            throw new IOException("Could not find legacy.json");
        }
        String data = Resources.toString(url, Charset.defaultCharset());
        LegacyDataFile dataFile = (LegacyDataFile)gson.fromJson(data, new TypeToken<LegacyDataFile>(){}.getType());
        DataFixer fixer = WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.WORLD_EDITING).getDataFixer();
        ParserContext parserContext = new ParserContext();
        parserContext.setPreferringWildcard(false);
        parserContext.setRestricted(false);
        parserContext.setTryLegacy(false);
        for (Map.Entry blockEntry : dataFile.blocks.entrySet()) {
            id = (String)blockEntry.getKey();
            value = (String)blockEntry.getValue();
            this.blockEntries.put(id, value);
            try {
                BlockState state = ((BaseBlock)WorldEdit.getInstance().getBlockFactory().parseFromInput(value, parserContext)).toImmutableState();
                this.blockToStringMap.put(state, id);
                this.stringToBlockMap.put(id, state);
            }
            catch (InputParseException e) {
                boolean fixed = false;
                if (fixer != null) {
                    String newEntry = fixer.fixUp(DataFixer.FixTypes.BLOCK_STATE, value, 1631);
                    try {
                        BlockState state = ((BaseBlock)WorldEdit.getInstance().getBlockFactory().parseFromInput(newEntry, parserContext)).toImmutableState();
                        this.blockToStringMap.put(state, id);
                        this.stringToBlockMap.put(id, state);
                        fixed = true;
                    }
                    catch (InputParseException inputParseException) {
                        // empty catch block
                    }
                }
                if (fixed) continue;
                log.warn("Unknown block: " + value);
            }
        }
        for (Map.Entry itemEntry : dataFile.items.entrySet()) {
            id = (String)itemEntry.getKey();
            value = (String)itemEntry.getValue();
            ItemType type = ItemTypes.get(value);
            if (type == null && fixer != null) {
                value = fixer.fixUp(DataFixer.FixTypes.ITEM_TYPE, value, 1631);
                type = ItemTypes.get(value);
            }
            if (type == null) {
                log.warn("Unknown item: " + value);
                continue;
            }
            this.itemToStringMap.put(type, id);
            this.stringToItemMap.put(id, type);
        }
    }

    @Nullable
    public ItemType getItemFromLegacy(int legacyId) {
        return this.getItemFromLegacy(legacyId, 0);
    }

    @Nullable
    public ItemType getItemFromLegacy(int legacyId, int data) {
        return this.stringToItemMap.get(legacyId + ":" + data);
    }

    @Nullable
    public int[] getLegacyFromItem(ItemType itemType) {
        if (this.itemToStringMap.containsKey(itemType)) {
            String value = this.itemToStringMap.get(itemType).stream().findFirst().get();
            return Arrays.stream(value.split(":")).mapToInt(Integer::parseInt).toArray();
        }
        return null;
    }

    @Nullable
    public BlockState getBlockFromLegacy(int legacyId) {
        return this.getBlockFromLegacy(legacyId, 0);
    }

    @Nullable
    public BlockState getBlockFromLegacy(int legacyId, int data) {
        return this.stringToBlockMap.get(legacyId + ":" + data);
    }

    @Nullable
    public int[] getLegacyFromBlock(BlockState blockState) {
        if (this.blockToStringMap.containsKey(blockState)) {
            String value = this.blockToStringMap.get(blockState).stream().findFirst().get();
            return Arrays.stream(value.split(":")).mapToInt(Integer::parseInt).toArray();
        }
        return null;
    }

    public static LegacyMapper getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LegacyMapper();
        }
        return INSTANCE;
    }

    private static class LegacyDataFile {
        private Map<String, String> blocks;
        private Map<String, String> items;

        private LegacyDataFile() {
        }
    }
}

