/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world.registry;

import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.util.gson.VectorAdapter;
import com.sk89q.worldedit.util.io.ResourceLoader;
import com.sk89q.worldedit.world.registry.BlockMaterial;
import com.sk89q.worldedit.world.registry.SimpleBlockMaterial;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BundledBlockData {
    private static final Logger log = LoggerFactory.getLogger(BundledBlockData.class);
    private static BundledBlockData INSTANCE;
    private final Map<String, BlockEntry> idMap = new HashMap<String, BlockEntry>();

    private BundledBlockData() {
        try {
            this.loadFromResource();
        }
        catch (Throwable e) {
            log.warn("Failed to load the built-in block registry", e);
        }
    }

    private void loadFromResource() throws IOException {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter((Type)((Object)Vector3.class), new VectorAdapter());
        Gson gson = gsonBuilder.create();
        URL url = null;
        int dataVersion = WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.WORLD_EDITING).getDataVersion();
        if (dataVersion > 1900) {
            url = ResourceLoader.getResource(BundledBlockData.class, "blocks.114.json");
        }
        if (url == null) {
            url = ResourceLoader.getResource(BundledBlockData.class, "blocks.json");
        }
        if (url == null) {
            throw new IOException("Could not find blocks.json");
        }
        log.debug("Using {} for bundled block data.", (Object)url);
        String data = Resources.toString(url, Charset.defaultCharset());
        List entries = (List)gson.fromJson(data, new TypeToken<List<BlockEntry>>(){}.getType());
        for (BlockEntry entry : entries) {
            this.idMap.put(entry.id, entry);
        }
    }

    @Nullable
    public BlockEntry findById(String id) {
        if (!id.contains(":")) {
            id = "minecraft:" + id;
        }
        return this.idMap.get(id);
    }

    @Nullable
    public BlockMaterial getMaterialById(String id) {
        BlockEntry entry = this.findById(id);
        if (entry != null) {
            return entry.material;
        }
        return null;
    }

    public static BundledBlockData getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BundledBlockData();
        }
        return INSTANCE;
    }

    public static class BlockEntry {
        private String id;
        public String localizedName;
        private SimpleBlockMaterial material = new SimpleBlockMaterial();
    }
}

