/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util.formatting.component;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.sk89q.worldedit.util.formatting.component.TextComponentProducer;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.format.TextColor;
import com.sk89q.worldedit.util.formatting.text.format.TextDecoration;

public class MessageBox
extends TextComponentProducer {
    private static final int GUARANTEED_NO_WRAP_CHAT_PAGE_WIDTH = 47;
    private TextComponentProducer contents;

    public MessageBox(String title, TextComponentProducer contents) {
        Preconditions.checkNotNull(title);
        this.append(this.centerAndBorder(TextComponent.of((String)title))).newline();
        this.contents = contents;
    }

    protected Component centerAndBorder(TextComponent text) {
        TextComponentProducer line = new TextComponentProducer();
        int leftOver = 47 - MessageBox.getLength(text);
        int side = (int)Math.floor((double)leftOver / 2.0);
        if (side > 0) {
            if (side > 1) {
                line.append((Component)this.createBorder(side - 1));
            }
            line.append((Component)TextComponent.space());
        }
        line.append((Component)text);
        if (side > 0) {
            line.append((Component)TextComponent.space());
            if (side > 1) {
                line.append((Component)this.createBorder(side - 1));
            }
        }
        return line.create();
    }

    private static int getLength(TextComponent text) {
        return text.content().length() + text.children().stream().filter(c -> c instanceof TextComponent).mapToInt(c -> MessageBox.getLength((TextComponent)c)).sum();
    }

    private TextComponent createBorder(int count) {
        return TextComponent.of((String)Strings.repeat("-", count), (TextColor)TextColor.YELLOW, Sets.newHashSet(TextDecoration.STRIKETHROUGH));
    }

    public TextComponentProducer getContents() {
        return this.contents;
    }

    @Override
    public TextComponent create() {
        this.append((Component)this.contents.create());
        return super.create();
    }
}

