/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util.eventbus;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.sk89q.worldedit.util.eventbus.AnnotatedSubscriberFinder;
import com.sk89q.worldedit.util.eventbus.EventHandler;
import com.sk89q.worldedit.util.eventbus.HierarchyCache;
import com.sk89q.worldedit.util.eventbus.SubscriberFindingStrategy;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventBus {
    private final Logger logger = LoggerFactory.getLogger(EventBus.class);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final SetMultimap<Class<?>, EventHandler> handlersByType = HashMultimap.create();
    private final SubscriberFindingStrategy finder = new AnnotatedSubscriberFinder();
    private HierarchyCache flattenHierarchyCache = new HierarchyCache();

    public void subscribe(Class<?> clazz, EventHandler handler) {
        Preconditions.checkNotNull(clazz);
        Preconditions.checkNotNull(handler);
        this.lock.writeLock().lock();
        try {
            this.handlersByType.put(clazz, handler);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void subscribeAll(Multimap<Class<?>, EventHandler> handlers) {
        Preconditions.checkNotNull(handlers);
        this.lock.writeLock().lock();
        try {
            this.handlersByType.putAll(handlers);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void unsubscribe(Class<?> clazz, EventHandler handler) {
        Preconditions.checkNotNull(clazz);
        Preconditions.checkNotNull(handler);
        this.lock.writeLock().lock();
        try {
            this.handlersByType.remove(clazz, handler);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeAll(Multimap<Class<?>, EventHandler> handlers) {
        Preconditions.checkNotNull(handlers);
        this.lock.writeLock().lock();
        try {
            for (Map.Entry<Class<?>, Collection<EventHandler>> entry : handlers.asMap().entrySet()) {
                this.handlersByType.get((Object)entry.getKey()).removeAll(entry.getValue());
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void register(Object object) {
        this.subscribeAll(this.finder.findAllSubscribers(object));
    }

    public void unregister(Object object) {
        this.unsubscribeAll(this.finder.findAllSubscribers(object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post(Object event) {
        ArrayList dispatching = new ArrayList();
        Set<Class<?>> dispatchTypes = this.flattenHierarchyCache.get(event.getClass());
        this.lock.readLock().lock();
        try {
            for (Class<?> eventType : dispatchTypes) {
                Collection wrappers = this.handlersByType.get((Object)eventType);
                if (wrappers == null || wrappers.isEmpty()) continue;
                dispatching.addAll(wrappers);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        Collections.sort(dispatching);
        for (EventHandler handler : dispatching) {
            this.dispatch(event, handler);
        }
    }

    private void dispatch(Object event, EventHandler handler) {
        try {
            handler.handleEvent(event);
        }
        catch (InvocationTargetException e) {
            this.logger.error("Could not dispatch event: " + event + " to handler " + handler, e);
        }
    }
}

