/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.block.BaseBlock;
import java.util.Objects;

public final class LocatedBlock {
    private final BlockVector3 location;
    private final BaseBlock block;

    public LocatedBlock(BlockVector3 location, BaseBlock block) {
        this.location = Preconditions.checkNotNull(location);
        this.block = Preconditions.checkNotNull(block);
    }

    public BlockVector3 getLocation() {
        return this.location;
    }

    public BaseBlock getBlock() {
        return this.block;
    }

    public int hashCode() {
        return Objects.hash(this.location, this.block);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocatedBlock lb = (LocatedBlock)obj;
        return Objects.equals(this.location, lb.location) && Objects.equals(this.block, lb.block);
    }
}

