/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.regions.shape;

import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.internal.expression.runtime.ExpressionEnvironment;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;

public class WorldEditExpressionEnvironment
implements ExpressionEnvironment {
    private final Vector3 unit;
    private final Vector3 zero2;
    private Vector3 current = Vector3.ZERO;
    private Extent extent;

    public WorldEditExpressionEnvironment(Extent extent, Vector3 unit, Vector3 zero) {
        this.extent = extent;
        this.unit = unit;
        this.zero2 = zero.add(0.5, 0.5, 0.5);
    }

    public BlockVector3 toWorld(double x, double y, double z) {
        return Vector3.at(x, y, z).multiply(this.unit).add(this.zero2).toBlockPoint();
    }

    public Vector3 toWorldRel(double x, double y, double z) {
        return this.current.add(x, y, z);
    }

    @Override
    public int getBlockType(double x, double y, double z) {
        return this.extent.getBlock(this.toWorld(x, y, z)).getBlockType().getLegacyId();
    }

    @Override
    public int getBlockData(double x, double y, double z) {
        return 0;
    }

    @Override
    public int getBlockTypeAbs(double x, double y, double z) {
        return this.extent.getBlock(BlockVector3.at(x, y, z)).getBlockType().getLegacyId();
    }

    @Override
    public int getBlockDataAbs(double x, double y, double z) {
        return 0;
    }

    @Override
    public int getBlockTypeRel(double x, double y, double z) {
        return this.extent.getBlock(this.toWorldRel(x, y, z).toBlockPoint()).getBlockType().getLegacyId();
    }

    @Override
    public int getBlockDataRel(double x, double y, double z) {
        return 0;
    }

    public void setCurrentBlock(Vector3 current) {
        this.current = current;
    }
}

