/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.internal.command.exception;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.DisallowedItemException;
import com.sk89q.worldedit.EmptyClipboardException;
import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.InvalidItemException;
import com.sk89q.worldedit.MaxBrushRadiusException;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.MaxRadiusException;
import com.sk89q.worldedit.UnknownDirectionException;
import com.sk89q.worldedit.UnknownItemException;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.InsufficientArgumentsException;
import com.sk89q.worldedit.command.tool.InvalidToolBindException;
import com.sk89q.worldedit.internal.command.exception.ExceptionConverterHelper;
import com.sk89q.worldedit.internal.command.exception.ExceptionMatch;
import com.sk89q.worldedit.internal.expression.ExpressionException;
import com.sk89q.worldedit.regions.RegionOperationException;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.io.file.FileSelectionAbortedException;
import com.sk89q.worldedit.util.io.file.FilenameResolutionException;
import com.sk89q.worldedit.util.io.file.InvalidFilenameException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.enginehub.piston.exception.CommandException;
import org.enginehub.piston.exception.UsageException;

public class WorldEditExceptionConverter
extends ExceptionConverterHelper {
    private static final Pattern numberFormat = Pattern.compile("^For input string: \"(.*)\"$");
    private final WorldEdit worldEdit;

    public WorldEditExceptionConverter(WorldEdit worldEdit) {
        Preconditions.checkNotNull(worldEdit);
        this.worldEdit = worldEdit;
    }

    private CommandException newCommandException(String message, Throwable cause) {
        return new CommandException((Component)TextComponent.of((String)String.valueOf(message)), cause, ImmutableList.of());
    }

    @ExceptionMatch
    public void convert(NumberFormatException e) throws CommandException {
        Matcher matcher = numberFormat.matcher(e.getMessage());
        if (matcher.matches()) {
            throw this.newCommandException("Number expected; string \"" + matcher.group(1) + "\" given.", e);
        }
        throw this.newCommandException("Number expected; string given.", e);
    }

    @ExceptionMatch
    public void convert(IncompleteRegionException e) throws CommandException {
        throw this.newCommandException("Make a region selection first.", e);
    }

    @ExceptionMatch
    public void convert(UnknownItemException e) throws CommandException {
        throw this.newCommandException("Block name '" + e.getID() + "' was not recognized.", e);
    }

    @ExceptionMatch
    public void convert(InvalidItemException e) throws CommandException {
        throw this.newCommandException(e.getMessage(), e);
    }

    @ExceptionMatch
    public void convert(DisallowedItemException e) throws CommandException {
        throw this.newCommandException("Block '" + e.getID() + "' not allowed (see WorldEdit configuration).", e);
    }

    @ExceptionMatch
    public void convert(MaxChangedBlocksException e) throws CommandException {
        throw this.newCommandException("Max blocks changed in an operation reached (" + e.getBlockLimit() + ").", e);
    }

    @ExceptionMatch
    public void convert(MaxBrushRadiusException e) throws CommandException {
        throw this.newCommandException("Maximum brush radius (in configuration): " + this.worldEdit.getConfiguration().maxBrushRadius, e);
    }

    @ExceptionMatch
    public void convert(MaxRadiusException e) throws CommandException {
        throw this.newCommandException("Maximum radius (in configuration): " + this.worldEdit.getConfiguration().maxRadius, e);
    }

    @ExceptionMatch
    public void convert(UnknownDirectionException e) throws CommandException {
        throw this.newCommandException("Unknown direction: " + e.getDirection(), e);
    }

    @ExceptionMatch
    public void convert(InsufficientArgumentsException e) throws CommandException {
        throw this.newCommandException(e.getMessage(), e);
    }

    @ExceptionMatch
    public void convert(RegionOperationException e) throws CommandException {
        throw this.newCommandException(e.getMessage(), e);
    }

    @ExceptionMatch
    public void convert(ExpressionException e) throws CommandException {
        throw this.newCommandException(e.getMessage(), e);
    }

    @ExceptionMatch
    public void convert(EmptyClipboardException e) throws CommandException {
        throw this.newCommandException("Your clipboard is empty. Use //copy first.", e);
    }

    @ExceptionMatch
    public void convert(InvalidFilenameException e) throws CommandException {
        throw this.newCommandException("Filename '" + e.getFilename() + "' invalid: " + e.getMessage(), e);
    }

    @ExceptionMatch
    public void convert(FilenameResolutionException e) throws CommandException {
        throw this.newCommandException("File '" + e.getFilename() + "' resolution error: " + e.getMessage(), e);
    }

    @ExceptionMatch
    public void convert(InvalidToolBindException e) throws CommandException {
        throw this.newCommandException("Can't bind tool to " + e.getItemType().getName() + ": " + e.getMessage(), e);
    }

    @ExceptionMatch
    public void convert(FileSelectionAbortedException e) throws CommandException {
        throw this.newCommandException("File selection aborted.", e);
    }

    @ExceptionMatch
    public void convert(WorldEditException e) throws CommandException {
        throw this.newCommandException(e.getMessage(), e);
    }

    @ExceptionMatch
    public void convert(UsageException e) throws CommandException {
        throw e;
    }
}

