/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.internal.command;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.command.util.Logging;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.math.Vector3;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.logging.Handler;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.inject.Key;

public class CommandLoggingHandler
implements CommandCallListener,
AutoCloseable {
    private final WorldEdit worldEdit;
    private final Logger logger;

    public CommandLoggingHandler(WorldEdit worldEdit, Logger logger) {
        Preconditions.checkNotNull(worldEdit);
        Preconditions.checkNotNull(logger);
        this.worldEdit = worldEdit;
        this.logger = logger;
    }

    public void beforeCall(Method method, CommandParameters parameters) {
        Logging loggingAnnotation = method.getAnnotation(Logging.class);
        StringBuilder builder = new StringBuilder();
        Logging.LogMode logMode = loggingAnnotation == null ? null : loggingAnnotation.value();
        Optional<Player> playerOpt = parameters.injectedValue(Key.of(Actor.class)).filter(Player.class::isInstance).map(Player.class::cast);
        if (!playerOpt.isPresent()) {
            return;
        }
        Player player = playerOpt.get();
        builder.append("WorldEdit: ").append(player.getName());
        builder.append(" (in \"").append(player.getWorld().getName()).append("\")");
        builder.append(": ").append(parameters.getMetadata().getCalledName());
        builder.append(": ").append(Stream.concat(Stream.of(parameters.getMetadata().getCalledName()), parameters.getMetadata().getArguments().stream()).collect(Collectors.joining(" ")));
        if (logMode != null) {
            Vector3 position = player.getLocation().toVector();
            LocalSession session = this.worldEdit.getSessionManager().get(player);
            switch (logMode) {
                case PLACEMENT: {
                    try {
                        position = session.getPlacementPosition(player).toVector3();
                    }
                    catch (IncompleteRegionException e) {
                        break;
                    }
                }
                case POSITION: {
                    builder.append(" - Position: ").append(position);
                    break;
                }
                case ALL: {
                    builder.append(" - Position: ").append(position);
                }
                case ORIENTATION_REGION: {
                    builder.append(" - Orientation: ").append(player.getCardinalDirection().name());
                }
                case REGION: {
                    try {
                        builder.append(" - Region: ").append(session.getSelection(player.getWorld()));
                    }
                    catch (IncompleteRegionException e) {}
                    break;
                }
            }
        }
        this.logger.info(builder.toString());
    }

    @Override
    public void close() {
        for (Handler h : this.logger.getHandlers()) {
            h.close();
        }
    }
}

