/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.internal.block;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.sk89q.worldedit.world.block.BlockState;
import java.util.OptionalInt;
import javax.annotation.Nullable;

public final class BlockStateIdAccess {
    private static final BiMap<BlockState, Integer> ASSIGNED_IDS = HashBiMap.create(16384);

    public static OptionalInt getBlockStateId(BlockState holder) {
        Integer value = (Integer)ASSIGNED_IDS.get(holder);
        return value == null ? OptionalInt.empty() : OptionalInt.of(value);
    }

    @Nullable
    public static BlockState getBlockStateById(int id) {
        return (BlockState)ASSIGNED_IDS.inverse().get(id);
    }

    public static void register(BlockState blockState, OptionalInt id) {
        if (id.isPresent()) {
            int i = id.getAsInt();
            BlockState existing = (BlockState)ASSIGNED_IDS.inverse().get(i);
            Preconditions.checkState(existing == null || existing == blockState, "BlockState %s is using the same block ID (%s) as BlockState %s", (Object)blockState, (Object)i, (Object)existing);
            ASSIGNED_IDS.put(blockState, i);
        }
    }

    public static void clear() {
        ASSIGNED_IDS.clear();
    }

    private BlockStateIdAccess() {
    }
}

