/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.operation;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.RunContext;
import com.sk89q.worldedit.util.LocatedBlock;
import java.util.List;

public class SetLocatedBlocks
implements Operation {
    private final Extent extent;
    private final Iterable<LocatedBlock> blocks;

    public SetLocatedBlocks(Extent extent, Iterable<LocatedBlock> blocks) {
        this.extent = Preconditions.checkNotNull(extent);
        this.blocks = Preconditions.checkNotNull(blocks);
    }

    @Override
    public Operation resume(RunContext run) throws WorldEditException {
        for (LocatedBlock block : this.blocks) {
            this.extent.setBlock(block.getLocation(), block.getBlock());
        }
        return null;
    }

    @Override
    public void cancel() {
    }

    @Override
    public void addStatusMessages(List<String> messages) {
    }
}

