/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.biome;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.FlatRegionFunction;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.transform.Transform;
import com.sk89q.worldedit.world.biome.BiomeType;

public class ExtentBiomeCopy
implements FlatRegionFunction {
    private final Extent source;
    private final Extent destination;
    private final BlockVector2 from;
    private final BlockVector2 to;
    private final Transform transform;

    public ExtentBiomeCopy(Extent source, BlockVector2 from, Extent destination, BlockVector2 to, Transform transform) {
        Preconditions.checkNotNull(source);
        Preconditions.checkNotNull(from);
        Preconditions.checkNotNull(destination);
        Preconditions.checkNotNull(to);
        Preconditions.checkNotNull(transform);
        this.source = source;
        this.from = from;
        this.destination = destination;
        this.to = to;
        this.transform = transform;
    }

    @Override
    public boolean apply(BlockVector2 position) throws WorldEditException {
        BiomeType biome = this.source.getBiome(position);
        BlockVector2 orig = position.subtract(this.from);
        BlockVector2 transformed = this.transform.apply(orig.toVector3(0.0)).toVector2().toBlockPoint();
        return this.destination.setBiome(transformed.add(this.to), biome);
    }
}

