/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.world;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.RunContext;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class FastModeExtent
extends AbstractDelegateExtent {
    private final World world;
    private final Set<BlockVector3> positions = new HashSet<BlockVector3>();
    private final Set<BlockVector2> dirtyChunks = new HashSet<BlockVector2>();
    private boolean enabled = true;
    private boolean postEditSimulation;

    public FastModeExtent(World world) {
        this(world, true);
    }

    public FastModeExtent(World world, boolean enabled) {
        super(world);
        Preconditions.checkNotNull(world);
        this.world = world;
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isPostEditSimulationEnabled() {
        return this.postEditSimulation;
    }

    public void setPostEditSimulationEnabled(boolean enabled) {
        this.postEditSimulation = enabled;
    }

    public <B extends BlockStateHolder<B>> boolean setBlock(BlockVector3 location, B block) throws WorldEditException {
        if (this.enabled || this.postEditSimulation) {
            this.dirtyChunks.add(BlockVector2.at(location.getBlockX() >> 4, location.getBlockZ() >> 4));
            if (this.world.setBlock(location, block, false)) {
                if (!this.enabled && this.postEditSimulation) {
                    this.positions.add(location);
                }
                return true;
            }
            return false;
        }
        return this.world.setBlock(location, block, true);
    }

    public boolean commitRequired() {
        return this.enabled || this.postEditSimulation;
    }

    @Override
    protected Operation commitBefore() {
        if (!this.commitRequired()) {
            return null;
        }
        return new Operation(){

            @Override
            public Operation resume(RunContext run) throws WorldEditException {
                if (!FastModeExtent.this.dirtyChunks.isEmpty()) {
                    FastModeExtent.this.world.fixAfterFastMode(FastModeExtent.this.dirtyChunks);
                }
                if (!FastModeExtent.this.enabled && FastModeExtent.this.postEditSimulation) {
                    Iterator positionIterator = FastModeExtent.this.positions.iterator();
                    while (run.shouldContinue() && positionIterator.hasNext()) {
                        BlockVector3 position = (BlockVector3)positionIterator.next();
                        FastModeExtent.this.world.notifyAndLightBlock(position, BlockTypes.AIR.getDefaultState());
                        positionIterator.remove();
                    }
                    return !FastModeExtent.this.positions.isEmpty() ? this : null;
                }
                return null;
            }

            @Override
            public void cancel() {
            }

            @Override
            public void addStatusMessages(List<String> messages) {
            }
        };
    }
}

