/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.validation;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;

public class DataValidatorExtent
extends AbstractDelegateExtent {
    private final World world;

    public DataValidatorExtent(Extent extent, World world) {
        super(extent);
        Preconditions.checkNotNull(world);
        this.world = world;
    }

    public <B extends BlockStateHolder<B>> boolean setBlock(BlockVector3 location, B block) throws WorldEditException {
        int y = location.getBlockY();
        BlockType type = block.getBlockType();
        if (y < 0 || y > this.world.getMaxY()) {
            return false;
        }
        if (type == null) {
            return false;
        }
        return super.setBlock(location, block);
    }
}

