/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.reorder;

import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.AbstractBufferingExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.RunContext;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class ChunkBatchingExtent
extends AbstractBufferingExtent {
    private static final Comparator<BlockVector2> REGION_OPTIMIZED_SORT = Comparator.comparing(vec -> vec.shr(5), BlockVector2.COMPARING_GRID_ARRANGEMENT).thenComparing(BlockVector2.COMPARING_GRID_ARRANGEMENT);
    private final Table<BlockVector2, BlockVector3, BaseBlock> batches = TreeBasedTable.create(REGION_OPTIMIZED_SORT, BlockVector3.sortByCoordsYzx());
    private final Set<BlockVector3> containedBlocks = new HashSet<BlockVector3>();
    private boolean enabled;

    public ChunkBatchingExtent(Extent extent) {
        this(extent, true);
    }

    public ChunkBatchingExtent(Extent extent, boolean enabled) {
        super(extent);
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean commitRequired() {
        return this.enabled;
    }

    private BlockVector2 getChunkPos(BlockVector3 location) {
        return location.shr(4).toBlockVector2();
    }

    private BlockVector3 getInChunkPos(BlockVector3 location) {
        return BlockVector3.at(location.getX() & 0xF, location.getY(), location.getZ() & 0xF);
    }

    public <B extends BlockStateHolder<B>> boolean setBlock(BlockVector3 location, B block) throws WorldEditException {
        if (!this.enabled) {
            return this.setDelegateBlock(location, block);
        }
        BlockVector2 chunkPos = this.getChunkPos(location);
        BlockVector3 inChunkPos = this.getInChunkPos(location);
        this.batches.put(chunkPos, inChunkPos, block.toBaseBlock());
        this.containedBlocks.add(location);
        return true;
    }

    @Override
    protected Optional<BaseBlock> getBufferedBlock(BlockVector3 position) {
        if (!this.containedBlocks.contains(position)) {
            return Optional.empty();
        }
        return Optional.of(this.batches.get(this.getChunkPos(position), this.getInChunkPos(position)));
    }

    @Override
    protected Operation commitBefore() {
        if (!this.commitRequired()) {
            return null;
        }
        return new Operation(){
            private Iterator<Map.Entry<BlockVector2, Map<BlockVector3, BaseBlock>>> batchIterator;

            @Override
            public Operation resume(RunContext run) throws WorldEditException {
                if (this.batchIterator == null) {
                    this.batchIterator = ChunkBatchingExtent.this.batches.rowMap().entrySet().iterator();
                }
                if (!this.batchIterator.hasNext()) {
                    return null;
                }
                Map.Entry<BlockVector2, Map<BlockVector3, BaseBlock>> next = this.batchIterator.next();
                BlockVector3 chunkOffset = next.getKey().toBlockVector3().shl(4);
                for (Map.Entry<BlockVector3, BaseBlock> block : next.getValue().entrySet()) {
                    ChunkBatchingExtent.this.getExtent().setBlock(block.getKey().add(chunkOffset), (BlockStateHolder)block.getValue());
                    ChunkBatchingExtent.this.containedBlocks.remove(block.getKey());
                }
                this.batchIterator.remove();
                return this;
            }

            @Override
            public void cancel() {
            }

            @Override
            public void addStatusMessages(List<String> messages) {
            }
        };
    }
}

