/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.buffer;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.AbstractBufferingExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.Masks;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.Map;
import java.util.Optional;

public class ExtentBuffer
extends AbstractBufferingExtent {
    private final Map<BlockVector3, BaseBlock> buffer = Maps.newHashMap();
    private final Mask mask;

    public ExtentBuffer(Extent delegate) {
        this(delegate, Masks.alwaysTrue());
    }

    public ExtentBuffer(Extent delegate, Mask mask) {
        super(delegate);
        Preconditions.checkNotNull(delegate);
        Preconditions.checkNotNull(mask);
        this.mask = mask;
    }

    @Override
    protected Optional<BaseBlock> getBufferedBlock(BlockVector3 position) {
        if (this.mask.test(position)) {
            return Optional.of(this.buffer.computeIfAbsent(position, pos -> this.getExtent().getFullBlock((BlockVector3)pos)));
        }
        return Optional.empty();
    }

    @Override
    public <T extends BlockStateHolder<T>> boolean setBlock(BlockVector3 location, T block) throws WorldEditException {
        if (this.mask.test(location)) {
            this.buffer.put(location, block.toBaseBlock());
            return true;
        }
        return false;
    }
}

