/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command.util;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.sk89q.worldedit.command.util.MessageTimerTask;
import com.sk89q.worldedit.extension.platform.Actor;
import java.util.Timer;
import java.util.TimerTask;

public class FutureProgressListener
implements Runnable {
    private static final Timer timer = new Timer();
    private static final int MESSAGE_DELAY = 1000;
    private final MessageTimerTask task;

    public FutureProgressListener(Actor sender, String message) {
        Preconditions.checkNotNull(sender);
        Preconditions.checkNotNull(message);
        this.task = new MessageTimerTask(sender, message);
        timer.schedule((TimerTask)this.task, 1000L);
    }

    @Override
    public void run() {
        this.task.cancel();
    }

    public static void addProgressListener(ListenableFuture<?> future, Actor sender, String message) {
        future.addListener(new FutureProgressListener(sender, message), MoreExecutors.directExecutor());
    }
}

