/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command.tool;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.command.tool.BlockTool;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Platform;
import com.sk89q.worldedit.internal.block.BlockStateIdAccess;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.event.HoverEvent;
import com.sk89q.worldedit.util.formatting.text.format.TextColor;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BaseBlock;
import java.util.OptionalInt;

public class QueryTool
implements BlockTool {
    @Override
    public boolean canUse(Actor player) {
        return player.hasPermission("worldedit.tool.info");
    }

    @Override
    public boolean actPrimary(Platform server, LocalConfiguration config, Player player, LocalSession session, Location clicked) {
        World world = (World)clicked.getExtent();
        EditSession editSession = session.createEditSession(player);
        BlockVector3 blockPoint = clicked.toVector().toBlockPoint();
        BaseBlock block = editSession.getFullBlock(blockPoint);
        TextComponent.Builder builder = TextComponent.builder();
        builder.append((Component)TextComponent.of((String)("@" + clicked.toVector().toBlockPoint() + ": "), (TextColor)TextColor.BLUE));
        builder.append((Component)TextComponent.of((String)block.getBlockType().getName(), (TextColor)TextColor.YELLOW));
        builder.append(TextComponent.of((String)(" (" + block + ") "), (TextColor)TextColor.GRAY).hoverEvent(HoverEvent.of((HoverEvent.Action)HoverEvent.Action.SHOW_TEXT, (Component)TextComponent.of((String)"Block state"))));
        OptionalInt internalId = BlockStateIdAccess.getBlockStateId(block.toImmutableState());
        if (internalId.isPresent()) {
            builder.append(TextComponent.of((String)(" (" + internalId.getAsInt() + ") "), (TextColor)TextColor.DARK_GRAY).hoverEvent(HoverEvent.of((HoverEvent.Action)HoverEvent.Action.SHOW_TEXT, (Component)TextComponent.of((String)"Internal ID"))));
        }
        builder.append(TextComponent.of((String)(" (" + world.getBlockLightLevel(blockPoint) + "/" + world.getBlockLightLevel(blockPoint.add(0, 1, 0)) + ")"), (TextColor)TextColor.WHITE).hoverEvent(HoverEvent.of((HoverEvent.Action)HoverEvent.Action.SHOW_TEXT, (Component)TextComponent.of((String)"Block Light/Light Above"))));
        player.print((Component)builder.build());
        return true;
    }
}

