/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command.argument;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.command.util.EntityRemover;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import java.util.List;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.converter.ArgumentConverter;
import org.enginehub.piston.converter.ConversionResult;
import org.enginehub.piston.converter.FailedConversion;
import org.enginehub.piston.converter.SuccessfulConversion;
import org.enginehub.piston.converter.SuggestionHelper;
import org.enginehub.piston.inject.InjectedValueAccess;
import org.enginehub.piston.inject.Key;

public class EntityRemoverConverter
implements ArgumentConverter<EntityRemover> {
    private final List<String> suggestions = ImmutableList.of("projectiles", "items", "paintings", "itemframes", "boats", "minecarts", "tnt", "xp", "all");

    public static void register(CommandManager commandManager) {
        commandManager.registerConverter(Key.of(EntityRemover.class), (ArgumentConverter)new EntityRemoverConverter());
    }

    private EntityRemoverConverter() {
    }

    public Component describeAcceptableArguments() {
        return TextComponent.of((String)"projectiles, items, paintings, itemframes, boats, minecarts, tnt, xp, or all");
    }

    public List<String> getSuggestions(String input) {
        return SuggestionHelper.limitByPrefix(this.suggestions.stream(), (String)input);
    }

    public ConversionResult<EntityRemover> convert(String argument, InjectedValueAccess context) {
        try {
            return SuccessfulConversion.fromSingle((Object)EntityRemover.fromString(argument));
        }
        catch (Exception e) {
            return FailedConversion.from((Throwable)e);
        }
    }
}

