/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command.argument;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import java.util.Collection;
import java.util.List;
import org.enginehub.piston.converter.ArgumentConverter;
import org.enginehub.piston.converter.ConversionResult;
import org.enginehub.piston.converter.SuccessfulConversion;
import org.enginehub.piston.inject.InjectedValueAccess;

public class CommaSeparatedValuesConverter<T>
implements ArgumentConverter<T> {
    private static final Splitter COMMA = Splitter.on(',');
    private final ArgumentConverter<T> delegate;
    private final int maximum;

    public static <T> CommaSeparatedValuesConverter<T> wrap(ArgumentConverter<T> delegate) {
        return CommaSeparatedValuesConverter.wrapAndLimit(delegate, -1);
    }

    public static <T> CommaSeparatedValuesConverter<T> wrapAndLimit(ArgumentConverter<T> delegate, int maximum) {
        return new CommaSeparatedValuesConverter<T>(delegate, maximum);
    }

    private CommaSeparatedValuesConverter(ArgumentConverter<T> delegate, int maximum) {
        Preconditions.checkArgument(maximum == -1 || maximum > 1, "Maximum must be bigger than 1, or exactly -1");
        this.delegate = delegate;
        this.maximum = maximum;
    }

    public Component describeAcceptableArguments() {
        TextComponent.Builder result = TextComponent.builder((String)"");
        if (this.maximum > -1) {
            ((TextComponent.Builder)((TextComponent.Builder)result.append((Component)TextComponent.of((String)"up to "))).append((Component)TextComponent.of((int)this.maximum))).append((Component)TextComponent.space());
        }
        ((TextComponent.Builder)result.append((Component)TextComponent.of((String)"comma separated values of: "))).append(this.delegate.describeAcceptableArguments());
        return result.build();
    }

    public List<String> getSuggestions(String input) {
        String lastInput = Iterables.getLast(COMMA.split(input), "");
        return this.delegate.getSuggestions(lastInput);
    }

    public ConversionResult<T> convert(String argument, InjectedValueAccess context) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (String input : COMMA.split(argument)) {
            ConversionResult temp = this.delegate.convert(input, context);
            if (!temp.isSuccessful()) {
                return temp;
            }
            result.addAll((Iterable)temp.get());
        }
        return SuccessfulConversion.from((Collection)result.build());
    }
}

