/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.WorldEditCommands;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.ArgAcceptingCommandFlag;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandParts;
import org.enginehub.piston.part.NoArgCommandFlag;

public final class WorldEditCommandsRegistration
implements CommandRegistration<WorldEditCommands>,
CommandPermissionsConditionGenerator.Registration {
    private static final Key<String> string_Key = Key.of(String.class);
    private static final Key<Integer> integer_Key = Key.of(Integer.class);
    private static final Key<Actor> actor_Key = Key.of(Actor.class);
    private static final Key<Player> player_Key = Key.of(Player.class);
    private static final Key<LocalSession> localSession_Key = Key.of(LocalSession.class);
    private CommandManager commandManager;
    private WorldEditCommands containerInstance;
    private CommandPermissionsConditionGenerator commandPermissionsConditionGenerator;
    private ImmutableList<CommandCallListener> listeners;
    private final NoArgCommandFlag pastebinPart = CommandParts.flag((char)'p', (Component)TextComponent.of((String)"Pastebins the report")).build();
    private final CommandArgument timezonePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"timezone"), (Component)TextComponent.of((String)"The timezone to set")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(string_Key)).build();
    private final NoArgCommandFlag listSubCommandsPart = CommandParts.flag((char)'s', (Component)TextComponent.of((String)"List sub-commands of the given command, if applicable")).build();
    private final ArgAcceptingCommandFlag pagePart = CommandParts.flag((char)'p', (Component)TextComponent.of((String)"The page to retrieve")).withRequiredArg().argNamed(TranslatableComponent.of((String)"page")).defaultsTo(ImmutableList.of("1")).ofTypes(ImmutableList.of(integer_Key)).build();
    private final CommandArgument commandPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"command"), (Component)TextComponent.of((String)"The command to retrieve help for")).defaultsTo(ImmutableList.of("")).ofTypes(ImmutableList.of(string_Key)).variable(true).build();

    private WorldEditCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static WorldEditCommandsRegistration builder() {
        return new WorldEditCommandsRegistration();
    }

    public WorldEditCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public WorldEditCommandsRegistration containerInstance(WorldEditCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    @Override
    public WorldEditCommandsRegistration commandPermissionsConditionGenerator(CommandPermissionsConditionGenerator commandPermissionsConditionGenerator) {
        this.commandPermissionsConditionGenerator = commandPermissionsConditionGenerator;
        return this;
    }

    public WorldEditCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    public void build() {
        this.commandManager.register("version", b -> {
            b.aliases(ImmutableList.of("ver"));
            b.description((Component)TextComponent.of((String)"Get WorldEdit version"));
            b.parts(ImmutableList.of());
            b.action(this::version);
        });
        this.commandManager.register("reload", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Reload configuration"));
            b.parts(ImmutableList.of());
            b.action(this::reload);
            Method commandMethod = RegistrationUtil.getCommandMethod(WorldEditCommands.class, (String)"reload", (Class[])new Class[]{Actor.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("report", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Writes a report on WorldEdit"));
            b.parts(ImmutableList.of(this.pastebinPart));
            b.action(this::report);
            Method commandMethod = RegistrationUtil.getCommandMethod(WorldEditCommands.class, (String)"report", (Class[])new Class[]{Actor.class, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("cui", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Complete CUI handshake (internal usage)"));
            b.parts(ImmutableList.of());
            b.action(this::cui);
        });
        this.commandManager.register("tz", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Set your timezone for snapshots"));
            b.parts(ImmutableList.of(this.timezonePart));
            b.action(this::tz);
        });
        this.commandManager.register("help", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Displays help for WorldEdit commands"));
            b.parts(ImmutableList.of(this.listSubCommandsPart, this.pagePart, this.commandPart));
            b.action(this::help);
            Method commandMethod = RegistrationUtil.getCommandMethod(WorldEditCommands.class, (String)"help", (Class[])new Class[]{Actor.class, Boolean.TYPE, Integer.TYPE, List.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
    }

    private int version(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(WorldEditCommands.class, (String)"version", (Class[])new Class[]{Actor.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.version(this.actor(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int reload(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(WorldEditCommands.class, (String)"reload", (Class[])new Class[]{Actor.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.reload(this.actor(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int report(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(WorldEditCommands.class, (String)"report", (Class[])new Class[]{Actor.class, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.report(this.actor(parameters), this.pastebin(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cui(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(WorldEditCommands.class, (String)"cui", (Class[])new Class[]{Player.class, LocalSession.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.cui(this.player(parameters), this.session(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int tz(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(WorldEditCommands.class, (String)"tz", (Class[])new Class[]{Player.class, LocalSession.class, String.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.tz(this.player(parameters), this.session(parameters), this.timezone(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int help(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(WorldEditCommands.class, (String)"help", (Class[])new Class[]{Actor.class, Boolean.TYPE, Integer.TYPE, List.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.help(this.actor(parameters), this.listSubCommands(parameters), this.page(parameters), this.command(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private Player player(CommandParameters parameters) {
        return (Player)RegistrationUtil.requireOptional(player_Key, (String)"player", (Optional)parameters.injectedValue(player_Key));
    }

    private List<String> command(CommandParameters parameters) {
        return this.commandPart.value(parameters).asMultiple(string_Key);
    }

    private LocalSession session(CommandParameters parameters) {
        return (LocalSession)RegistrationUtil.requireOptional(localSession_Key, (String)"session", (Optional)parameters.injectedValue(localSession_Key));
    }

    private boolean listSubCommands(CommandParameters parameters) {
        return this.listSubCommandsPart.in(parameters);
    }

    private String timezone(CommandParameters parameters) {
        return (String)this.timezonePart.value(parameters).asSingle(string_Key);
    }

    private Actor actor(CommandParameters parameters) {
        return (Actor)RegistrationUtil.requireOptional(actor_Key, (String)"actor", (Optional)parameters.injectedValue(actor_Key));
    }

    private boolean pastebin(CommandParameters parameters) {
        return this.pastebinPart.in(parameters);
    }

    private int page(CommandParameters parameters) {
        return (Integer)this.pagePart.value(parameters).asSingle(integer_Key);
    }
}

