/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.UtilityCommands;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.command.util.EntityRemover;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.ArgAcceptingCommandFlag;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandParts;
import org.enginehub.piston.part.NoArgCommandFlag;

public final class UtilityCommandsRegistration
implements CommandRegistration<UtilityCommands>,
CommandPermissionsConditionGenerator.Registration {
    private static final Key<Pattern> pattern_Key = Key.of(Pattern.class);
    private static final Key<Double> double_Key = Key.of(Double.class);
    private static final Key<Integer> integer_Key = Key.of(Integer.class);
    private static final Key<Mask> mask_Key = Key.of(Mask.class);
    private static final Key<EntityRemover> entityRemover_Key = Key.of(EntityRemover.class);
    private static final Key<String> string_Key = Key.of(String.class);
    private static final Key<Player> player_Key = Key.of(Player.class);
    private static final Key<LocalSession> localSession_Key = Key.of(LocalSession.class);
    private static final Key<EditSession> editSession_Key = Key.of(EditSession.class);
    private static final Key<Actor> actor_Key = Key.of(Actor.class);
    private CommandManager commandManager;
    private UtilityCommands containerInstance;
    private CommandPermissionsConditionGenerator commandPermissionsConditionGenerator;
    private ImmutableList<CommandCallListener> listeners;
    private final CommandArgument patternPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"pattern"), (Component)TextComponent.of((String)"The blocks to fill with")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(pattern_Key)).build();
    private final CommandArgument radiusPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radius"), (Component)TextComponent.of((String)"The radius to fill in")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(double_Key)).build();
    private final CommandArgument depthPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"depth"), (Component)TextComponent.of((String)"The depth to fill")).defaultsTo(ImmutableList.of("1")).ofTypes(ImmutableList.of(integer_Key)).build();
    private final CommandArgument depthPart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"depth"), (Component)TextComponent.of((String)"The depth to fill")).defaultsTo(ImmutableList.of("")).ofTypes(ImmutableList.of(integer_Key)).build();
    private final CommandArgument radiusPart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radius"), (Component)TextComponent.of((String)"The radius to drain")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(double_Key)).build();
    private final NoArgCommandFlag waterloggedPart = CommandParts.flag((char)'w', (Component)TextComponent.of((String)"Also un-waterlog blocks")).build();
    private final CommandArgument radiusPart3 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radius"), (Component)TextComponent.of((String)"The radius to fix in")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(double_Key)).build();
    private final CommandArgument sizePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"size"), (Component)TextComponent.of((String)"The apothem of the square to remove from")).defaultsTo(ImmutableList.of("1")).ofTypes(ImmutableList.of(integer_Key)).build();
    private final CommandArgument heightPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"height"), (Component)TextComponent.of((String)"The maximum height above you to remove from")).defaultsTo(ImmutableList.of("")).ofTypes(ImmutableList.of(integer_Key)).build();
    private final CommandArgument heightPart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"height"), (Component)TextComponent.of((String)"The maximum height below you to remove from")).defaultsTo(ImmutableList.of("")).ofTypes(ImmutableList.of(integer_Key)).build();
    private final CommandArgument maskPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"mask"), (Component)TextComponent.of((String)"The mask of blocks to remove")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(mask_Key)).build();
    private final CommandArgument radiusPart4 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radius"), (Component)TextComponent.of((String)"The radius of the square to remove from")).defaultsTo(ImmutableList.of("50")).ofTypes(ImmutableList.of(integer_Key)).build();
    private final CommandArgument radiusPart5 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radius"), (Component)TextComponent.of((String)"The radius of the square to remove in")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(integer_Key)).build();
    private final CommandArgument fromPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"from"), (Component)TextComponent.of((String)"The mask matching blocks to remove")).defaultsTo(ImmutableList.of("")).ofTypes(ImmutableList.of(mask_Key)).build();
    private final CommandArgument toPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"to"), (Component)TextComponent.of((String)"The pattern of blocks to replace with")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(pattern_Key)).build();
    private final CommandArgument sizePart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"size"), (Component)TextComponent.of((String)"The radius of the circle to snow in")).defaultsTo(ImmutableList.of("10")).ofTypes(ImmutableList.of(double_Key)).build();
    private final CommandArgument sizePart3 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"size"), (Component)TextComponent.of((String)"The radius of the circle to thaw in")).defaultsTo(ImmutableList.of("10")).ofTypes(ImmutableList.of(double_Key)).build();
    private final CommandArgument sizePart4 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"size"), (Component)TextComponent.of((String)"The radius of the circle to convert in")).defaultsTo(ImmutableList.of("10")).ofTypes(ImmutableList.of(double_Key)).build();
    private final NoArgCommandFlag convertCoarsePart = CommandParts.flag((char)'f', (Component)TextComponent.of((String)"Also convert coarse dirt")).build();
    private final CommandArgument radiusPart6 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radius"), (Component)TextComponent.of((String)"The radius of the square to remove in")).defaultsTo(ImmutableList.of("")).ofTypes(ImmutableList.of(integer_Key)).build();
    private final CommandArgument radiusPart7 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radius"), (Component)TextComponent.of((String)"Radius to kill mobs in")).defaultsTo(ImmutableList.of("")).ofTypes(ImmutableList.of(integer_Key)).build();
    private final NoArgCommandFlag killPetsPart = CommandParts.flag((char)'p', (Component)TextComponent.of((String)"Also kill pets")).build();
    private final NoArgCommandFlag killNpcsPart = CommandParts.flag((char)'n', (Component)TextComponent.of((String)"Also kill NPCs")).build();
    private final NoArgCommandFlag killGolemsPart = CommandParts.flag((char)'g', (Component)TextComponent.of((String)"Also kill golems")).build();
    private final NoArgCommandFlag killAnimalsPart = CommandParts.flag((char)'a', (Component)TextComponent.of((String)"Also kill animals")).build();
    private final NoArgCommandFlag killAmbientPart = CommandParts.flag((char)'b', (Component)TextComponent.of((String)"Also kill ambient mobs")).build();
    private final NoArgCommandFlag killWithNamePart = CommandParts.flag((char)'t', (Component)TextComponent.of((String)"Also kill mobs with name tags")).build();
    private final NoArgCommandFlag killFriendlyPart = CommandParts.flag((char)'f', (Component)TextComponent.of((String)"Also kill all friendly mobs (Applies the flags `-abgnpt`)")).build();
    private final NoArgCommandFlag killArmorStandsPart = CommandParts.flag((char)'r', (Component)TextComponent.of((String)"Also destroy armor stands")).build();
    private final CommandArgument removerPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"remover"), (Component)TextComponent.of((String)"The type of entity to remove")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(entityRemover_Key)).build();
    private final CommandArgument radiusPart8 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radius"), (Component)TextComponent.of((String)"The radius of the cuboid to remove from")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(integer_Key)).build();
    private final CommandArgument inputPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"input"), (Component)TextComponent.of((String)"Expression to evaluate")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(string_Key)).variable(true).build();
    private final NoArgCommandFlag listSubCommandsPart = CommandParts.flag((char)'s', (Component)TextComponent.of((String)"List sub-commands of the given command, if applicable")).build();
    private final ArgAcceptingCommandFlag pagePart = CommandParts.flag((char)'p', (Component)TextComponent.of((String)"The page to retrieve")).withRequiredArg().argNamed(TranslatableComponent.of((String)"page")).defaultsTo(ImmutableList.of("1")).ofTypes(ImmutableList.of(integer_Key)).build();
    private final CommandArgument commandPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"command"), (Component)TextComponent.of((String)"The command to retrieve help for")).defaultsTo(ImmutableList.of("")).ofTypes(ImmutableList.of(string_Key)).variable(true).build();

    private UtilityCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static UtilityCommandsRegistration builder() {
        return new UtilityCommandsRegistration();
    }

    public UtilityCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public UtilityCommandsRegistration containerInstance(UtilityCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    @Override
    public UtilityCommandsRegistration commandPermissionsConditionGenerator(CommandPermissionsConditionGenerator commandPermissionsConditionGenerator) {
        this.commandPermissionsConditionGenerator = commandPermissionsConditionGenerator;
        return this;
    }

    public UtilityCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    public void build() {
        this.commandManager.register("/fill", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Fill a hole"));
            b.parts(ImmutableList.of(this.patternPart, this.radiusPart, this.depthPart));
            b.action(this::_fill);
            Method commandMethod = RegistrationUtil.getCommandMethod(UtilityCommands.class, (String)"fill", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Pattern.class, Double.TYPE, Integer.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/fillr", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Fill a hole recursively"));
            b.parts(ImmutableList.of(this.patternPart, this.radiusPart, this.depthPart2));
            b.action(this::_fillr);
            Method commandMethod = RegistrationUtil.getCommandMethod(UtilityCommands.class, (String)"fillr", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Pattern.class, Double.TYPE, Integer.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/drain", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Drain a pool"));
            b.parts(ImmutableList.of(this.radiusPart2, this.waterloggedPart));
            b.action(this::_drain);
            Method commandMethod = RegistrationUtil.getCommandMethod(UtilityCommands.class, (String)"drain", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Double.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("fixlava", b -> {
            b.aliases(ImmutableList.of("/fixlava"));
            b.description((Component)TextComponent.of((String)"Fix lava to be stationary"));
            b.parts(ImmutableList.of(this.radiusPart3));
            b.action(this::fixlava);
            Method commandMethod = RegistrationUtil.getCommandMethod(UtilityCommands.class, (String)"fixLava", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Double.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("fixwater", b -> {
            b.aliases(ImmutableList.of("/fixwater"));
            b.description((Component)TextComponent.of((String)"Fix water to be stationary"));
            b.parts(ImmutableList.of(this.radiusPart3));
            b.action(this::fixwater);
            Method commandMethod = RegistrationUtil.getCommandMethod(UtilityCommands.class, (String)"fixWater", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Double.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("removeabove", b -> {
            b.aliases(ImmutableList.of("/removeabove"));
            b.description((Component)TextComponent.of((String)"Remove blocks above your head."));
            b.parts(ImmutableList.of(this.sizePart, this.heightPart));
            b.action(this::removeabove);
            Method commandMethod = RegistrationUtil.getCommandMethod(UtilityCommands.class, (String)"removeAbove", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Integer.TYPE, Integer.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("removebelow", b -> {
            b.aliases(ImmutableList.of("/removebelow"));
            b.description((Component)TextComponent.of((String)"Remove blocks below you."));
            b.parts(ImmutableList.of(this.sizePart, this.heightPart2));
            b.action(this::removebelow);
            Method commandMethod = RegistrationUtil.getCommandMethod(UtilityCommands.class, (String)"removeBelow", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Integer.TYPE, Integer.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("removenear", b -> {
            b.aliases(ImmutableList.of("/removenear"));
            b.description((Component)TextComponent.of((String)"Remove blocks near you."));
            b.parts(ImmutableList.of(this.maskPart, this.radiusPart4));
            b.action(this::removenear);
            Method commandMethod = RegistrationUtil.getCommandMethod(UtilityCommands.class, (String)"removeNear", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Mask.class, Integer.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("replacenear", b -> {
            b.aliases(ImmutableList.of("/replacenear"));
            b.description((Component)TextComponent.of((String)"Replace nearby blocks"));
            b.parts(ImmutableList.of(this.radiusPart5, this.fromPart, this.toPart));
            b.action(this::replacenear);
            Method commandMethod = RegistrationUtil.getCommandMethod(UtilityCommands.class, (String)"replaceNear", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Integer.TYPE, Mask.class, Pattern.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("snow", b -> {
            b.aliases(ImmutableList.of("/snow"));
            b.description((Component)TextComponent.of((String)"Simulates snow"));
            b.parts(ImmutableList.of(this.sizePart2));
            b.action(this::snow);
            Method commandMethod = RegistrationUtil.getCommandMethod(UtilityCommands.class, (String)"snow", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Double.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("thaw", b -> {
            b.aliases(ImmutableList.of("/thaw"));
            b.description((Component)TextComponent.of((String)"Thaws the area"));
            b.parts(ImmutableList.of(this.sizePart3));
            b.action(this::thaw);
            Method commandMethod = RegistrationUtil.getCommandMethod(UtilityCommands.class, (String)"thaw", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Double.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("green", b -> {
            b.aliases(ImmutableList.of("/green"));
            b.description((Component)TextComponent.of((String)"Converts dirt to grass blocks in the area"));
            b.parts(ImmutableList.of(this.sizePart4, this.convertCoarsePart));
            b.action(this::green);
            Method commandMethod = RegistrationUtil.getCommandMethod(UtilityCommands.class, (String)"green", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Double.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("extinguish", b -> {
            b.aliases(ImmutableList.of("/ex", "/ext", "/extinguish", "ex", "ext"));
            b.description((Component)TextComponent.of((String)"Extinguish nearby fire"));
            b.parts(ImmutableList.of(this.radiusPart6));
            b.action(this::extinguish);
            Method commandMethod = RegistrationUtil.getCommandMethod(UtilityCommands.class, (String)"extinguish", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Integer.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("butcher", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Kill all or nearby mobs"));
            b.parts(ImmutableList.of(this.radiusPart7, this.killPetsPart, this.killNpcsPart, this.killGolemsPart, this.killAnimalsPart, this.killAmbientPart, this.killWithNamePart, this.killFriendlyPart, this.killArmorStandsPart));
            b.action(this::butcher);
            Method commandMethod = RegistrationUtil.getCommandMethod(UtilityCommands.class, (String)"butcher", (Class[])new Class[]{Actor.class, Integer.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("remove", b -> {
            b.aliases(ImmutableList.of("rem", "rement"));
            b.description((Component)TextComponent.of((String)"Remove all entities of a type"));
            b.parts(ImmutableList.of(this.removerPart, this.radiusPart8));
            b.action(this::remove);
            Method commandMethod = RegistrationUtil.getCommandMethod(UtilityCommands.class, (String)"remove", (Class[])new Class[]{Actor.class, EntityRemover.class, Integer.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/calculate", b -> {
            b.aliases(ImmutableList.of("/calc", "/eval", "/evaluate", "/solve"));
            b.description((Component)TextComponent.of((String)"Evaluate a mathematical expression"));
            b.parts(ImmutableList.of(this.inputPart));
            b.action(this::_calculate);
            Method commandMethod = RegistrationUtil.getCommandMethod(UtilityCommands.class, (String)"calc", (Class[])new Class[]{Actor.class, List.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/help", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Displays help for WorldEdit commands"));
            b.parts(ImmutableList.of(this.listSubCommandsPart, this.pagePart, this.commandPart));
            b.action(this::_help);
            Method commandMethod = RegistrationUtil.getCommandMethod(UtilityCommands.class, (String)"help", (Class[])new Class[]{Actor.class, Boolean.TYPE, Integer.TYPE, List.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
    }

    private int _fill(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(UtilityCommands.class, (String)"fill", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Pattern.class, Double.TYPE, Integer.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.fill(this.player(parameters), this.session(parameters), this.editSession(parameters), this.pattern(parameters), this.radius(parameters), this.depth(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int _fillr(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(UtilityCommands.class, (String)"fillr", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Pattern.class, Double.TYPE, Integer.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.fillr(this.player(parameters), this.session(parameters), this.editSession(parameters), this.pattern(parameters), this.radius(parameters), this.depth2(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int _drain(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(UtilityCommands.class, (String)"drain", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Double.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.drain(this.player(parameters), this.session(parameters), this.editSession(parameters), this.radius2(parameters), this.waterlogged(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int fixlava(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(UtilityCommands.class, (String)"fixLava", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Double.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.fixLava(this.player(parameters), this.session(parameters), this.editSession(parameters), this.radius3(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int fixwater(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(UtilityCommands.class, (String)"fixWater", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Double.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.fixWater(this.player(parameters), this.session(parameters), this.editSession(parameters), this.radius3(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int removeabove(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(UtilityCommands.class, (String)"removeAbove", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Integer.TYPE, Integer.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.removeAbove(this.player(parameters), this.session(parameters), this.editSession(parameters), this.size(parameters), this.height(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int removebelow(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(UtilityCommands.class, (String)"removeBelow", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Integer.TYPE, Integer.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.removeBelow(this.player(parameters), this.session(parameters), this.editSession(parameters), this.size(parameters), this.height2(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int removenear(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(UtilityCommands.class, (String)"removeNear", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Mask.class, Integer.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.removeNear(this.player(parameters), this.session(parameters), this.editSession(parameters), this.mask(parameters), this.radius4(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int replacenear(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(UtilityCommands.class, (String)"replaceNear", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Integer.TYPE, Mask.class, Pattern.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.replaceNear(this.player(parameters), this.session(parameters), this.editSession(parameters), this.radius5(parameters), this.from(parameters), this.to(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int snow(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(UtilityCommands.class, (String)"snow", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Double.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.snow(this.player(parameters), this.session(parameters), this.editSession(parameters), this.size2(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int thaw(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(UtilityCommands.class, (String)"thaw", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Double.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.thaw(this.player(parameters), this.session(parameters), this.editSession(parameters), this.size3(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int green(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(UtilityCommands.class, (String)"green", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Double.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.green(this.player(parameters), this.session(parameters), this.editSession(parameters), this.size4(parameters), this.convertCoarse(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int extinguish(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(UtilityCommands.class, (String)"extinguish", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Integer.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.extinguish(this.player(parameters), this.session(parameters), this.editSession(parameters), this.radius6(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int butcher(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(UtilityCommands.class, (String)"butcher", (Class[])new Class[]{Actor.class, Integer.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.butcher(this.actor(parameters), this.radius7(parameters), this.killPets(parameters), this.killNpcs(parameters), this.killGolems(parameters), this.killAnimals(parameters), this.killAmbient(parameters), this.killWithName(parameters), this.killFriendly(parameters), this.killArmorStands(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int remove(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(UtilityCommands.class, (String)"remove", (Class[])new Class[]{Actor.class, EntityRemover.class, Integer.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.remove(this.actor(parameters), this.remover(parameters), this.radius8(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int _calculate(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(UtilityCommands.class, (String)"calc", (Class[])new Class[]{Actor.class, List.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.calc(this.actor(parameters), this.input(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int _help(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(UtilityCommands.class, (String)"help", (Class[])new Class[]{Actor.class, Boolean.TYPE, Integer.TYPE, List.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.help(this.actor(parameters), this.listSubCommands(parameters), this.page(parameters), this.command(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private Pattern pattern(CommandParameters parameters) {
        return (Pattern)this.patternPart.value(parameters).asSingle(pattern_Key);
    }

    private Player player(CommandParameters parameters) {
        return (Player)RegistrationUtil.requireOptional(player_Key, (String)"player", (Optional)parameters.injectedValue(player_Key));
    }

    private Integer depth2(CommandParameters parameters) {
        return (Integer)this.depthPart2.value(parameters).asSingle(integer_Key);
    }

    private LocalSession session(CommandParameters parameters) {
        return (LocalSession)RegistrationUtil.requireOptional(localSession_Key, (String)"session", (Optional)parameters.injectedValue(localSession_Key));
    }

    private double size4(CommandParameters parameters) {
        return (Double)this.sizePart4.value(parameters).asSingle(double_Key);
    }

    private boolean convertCoarse(CommandParameters parameters) {
        return this.convertCoarsePart.in(parameters);
    }

    private int radius8(CommandParameters parameters) {
        return (Integer)this.radiusPart8.value(parameters).asSingle(integer_Key);
    }

    private int page(CommandParameters parameters) {
        return (Integer)this.pagePart.value(parameters).asSingle(integer_Key);
    }

    private boolean killAnimals(CommandParameters parameters) {
        return this.killAnimalsPart.in(parameters);
    }

    private Integer height2(CommandParameters parameters) {
        return (Integer)this.heightPart2.value(parameters).asSingle(integer_Key);
    }

    private int size(CommandParameters parameters) {
        return (Integer)this.sizePart.value(parameters).asSingle(integer_Key);
    }

    private int radius5(CommandParameters parameters) {
        return (Integer)this.radiusPart5.value(parameters).asSingle(integer_Key);
    }

    private Integer radius7(CommandParameters parameters) {
        return (Integer)this.radiusPart7.value(parameters).asSingle(integer_Key);
    }

    private boolean killNpcs(CommandParameters parameters) {
        return this.killNpcsPart.in(parameters);
    }

    private Pattern to(CommandParameters parameters) {
        return (Pattern)this.toPart.value(parameters).asSingle(pattern_Key);
    }

    private List<String> command(CommandParameters parameters) {
        return this.commandPart.value(parameters).asMultiple(string_Key);
    }

    private boolean killFriendly(CommandParameters parameters) {
        return this.killFriendlyPart.in(parameters);
    }

    private boolean listSubCommands(CommandParameters parameters) {
        return this.listSubCommandsPart.in(parameters);
    }

    private Actor actor(CommandParameters parameters) {
        return (Actor)RegistrationUtil.requireOptional(actor_Key, (String)"actor", (Optional)parameters.injectedValue(actor_Key));
    }

    private double radius3(CommandParameters parameters) {
        return (Double)this.radiusPart3.value(parameters).asSingle(double_Key);
    }

    private Mask from(CommandParameters parameters) {
        return (Mask)this.fromPart.value(parameters).asSingle(mask_Key);
    }

    private double radius2(CommandParameters parameters) {
        return (Double)this.radiusPart2.value(parameters).asSingle(double_Key);
    }

    private int depth(CommandParameters parameters) {
        return (Integer)this.depthPart.value(parameters).asSingle(integer_Key);
    }

    private boolean waterlogged(CommandParameters parameters) {
        return this.waterloggedPart.in(parameters);
    }

    private boolean killArmorStands(CommandParameters parameters) {
        return this.killArmorStandsPart.in(parameters);
    }

    private boolean killPets(CommandParameters parameters) {
        return this.killPetsPart.in(parameters);
    }

    private double radius(CommandParameters parameters) {
        return (Double)this.radiusPart.value(parameters).asSingle(double_Key);
    }

    private boolean killWithName(CommandParameters parameters) {
        return this.killWithNamePart.in(parameters);
    }

    private double size2(CommandParameters parameters) {
        return (Double)this.sizePart2.value(parameters).asSingle(double_Key);
    }

    private double size3(CommandParameters parameters) {
        return (Double)this.sizePart3.value(parameters).asSingle(double_Key);
    }

    private EditSession editSession(CommandParameters parameters) {
        return (EditSession)RegistrationUtil.requireOptional(editSession_Key, (String)"editSession", (Optional)parameters.injectedValue(editSession_Key));
    }

    private List<String> input(CommandParameters parameters) {
        return this.inputPart.value(parameters).asMultiple(string_Key);
    }

    private Integer radius6(CommandParameters parameters) {
        return (Integer)this.radiusPart6.value(parameters).asSingle(integer_Key);
    }

    private Integer height(CommandParameters parameters) {
        return (Integer)this.heightPart.value(parameters).asSingle(integer_Key);
    }

    private boolean killGolems(CommandParameters parameters) {
        return this.killGolemsPart.in(parameters);
    }

    private boolean killAmbient(CommandParameters parameters) {
        return this.killAmbientPart.in(parameters);
    }

    private EntityRemover remover(CommandParameters parameters) {
        return (EntityRemover)this.removerPart.value(parameters).asSingle(entityRemover_Key);
    }

    private Mask mask(CommandParameters parameters) {
        return (Mask)this.maskPart.value(parameters).asSingle(mask_Key);
    }

    private int radius4(CommandParameters parameters) {
        return (Integer)this.radiusPart4.value(parameters).asSingle(integer_Key);
    }
}

