/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.util.CommandPermissions;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.util.HandSide;
import org.enginehub.piston.annotation.Command;

public class ToolUtilCommands {
    private final WorldEdit we;

    public ToolUtilCommands(WorldEdit we) {
        this.we = we;
    }

    @Command(name="/", aliases={","}, desc="Toggle the super pickaxe function")
    @CommandPermissions(value={"worldedit.superpickaxe"})
    public void togglePickaxe(Player player, LocalSession session, Boolean superPickaxe) {
        boolean hasSuperPickAxe = session.hasSuperPickAxe();
        if (superPickaxe != null && superPickaxe == hasSuperPickAxe) {
            player.printError("Super pickaxe already " + (superPickaxe != false ? "enabled" : "disabled") + ".");
            return;
        }
        if (hasSuperPickAxe) {
            session.disableSuperPickAxe();
            player.print("Super pickaxe disabled.");
        } else {
            session.enableSuperPickAxe();
            player.print("Super pickaxe enabled.");
        }
    }

    @Command(name="mask", desc="Set the brush mask")
    @CommandPermissions(value={"worldedit.brush.options.mask"})
    public void mask(Player player, LocalSession session, Mask mask) throws WorldEditException {
        session.getBrushTool(player.getItemInHand(HandSide.MAIN_HAND).getType()).setMask(mask);
        if (mask == null) {
            player.print("Brush mask disabled.");
        } else {
            player.print("Brush mask set.");
        }
    }

    @Command(name="material", aliases={"/material"}, desc="Set the brush material")
    @CommandPermissions(value={"worldedit.brush.options.material"})
    public void material(Player player, LocalSession session, Pattern pattern) throws WorldEditException {
        session.getBrushTool(player.getItemInHand(HandSide.MAIN_HAND).getType()).setFill(pattern);
        player.print("Brush material set.");
    }

    @Command(name="range", desc="Set the brush range")
    @CommandPermissions(value={"worldedit.brush.options.range"})
    public void range(Player player, LocalSession session, int range) throws WorldEditException {
        session.getBrushTool(player.getItemInHand(HandSide.MAIN_HAND).getType()).setRange(range);
        player.print("Brush range set.");
    }

    @Command(name="size", desc="Set the brush size")
    @CommandPermissions(value={"worldedit.brush.options.size"})
    public void size(Player player, LocalSession session, int size) throws WorldEditException {
        this.we.checkMaxBrushRadius(size);
        session.getBrushTool(player.getItemInHand(HandSide.MAIN_HAND).getType()).setSize(size);
        player.print("Brush size set.");
    }

    @Command(name="tracemask", desc="Set the mask used to stop tool traces")
    @CommandPermissions(value={"worldedit.brush.options.tracemask"})
    public void traceMask(Player player, LocalSession session, Mask mask) throws WorldEditException {
        session.getBrushTool(player.getItemInHand(HandSide.MAIN_HAND).getType()).setTraceMask(mask);
        if (mask == null) {
            player.print("Trace mask disabled.");
        } else {
            player.print("Trace mask set.");
        }
    }
}

